/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableAsList;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.collect.SortedIterable;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.UnmodifiableListIterator;
import java.util.Comparator;
import javax.annotation.Nullable;

final class ImmutableSortedAsList<E>
extends ImmutableList<E>
implements SortedIterable<E> {
    private final transient ImmutableSortedSet<E> backingSet;
    private final transient ImmutableList<E> backingList;

    ImmutableSortedAsList(ImmutableSortedSet<E> immutableSortedSet, ImmutableList<E> immutableList) {
        this.backingSet = immutableSortedSet;
        this.backingList = immutableList;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.backingSet.comparator();
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.backingSet.indexOf(object) >= 0;
    }

    @Override
    public int indexOf(@Nullable Object object) {
        return this.backingSet.indexOf(object);
    }

    @Override
    public int lastIndexOf(@Nullable Object object) {
        return this.backingSet.indexOf(object);
    }

    @Override
    public ImmutableList<E> subList(int n, int n2) {
        Preconditions.checkPositionIndexes(n, n2, this.size());
        return n == n2 ? ImmutableList.of() : new RegularImmutableSortedSet<E>(this.backingList.subList(n, n2), this.backingSet.comparator()).asList();
    }

    @Override
    Object writeReplace() {
        return new ImmutableAsList.SerializedForm(this.backingSet);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.backingList.iterator();
    }

    @Override
    public E get(int n) {
        return this.backingList.get(n);
    }

    @Override
    public UnmodifiableListIterator<E> listIterator() {
        return this.backingList.listIterator();
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int n) {
        return this.backingList.listIterator(n);
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return this.backingList.equals(object);
    }

    @Override
    public int hashCode() {
        return this.backingList.hashCode();
    }

    @Override
    boolean isPartialView() {
        return this.backingList.isPartialView();
    }
}

