/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.Collections2;
import com.google.common.collect.EmptyImmutableSet;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableAsList;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.RegularImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.SingletonImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    static final int MAX_TABLE_SIZE = 0x40000000;
    private static final double DESIRED_LOAD_FACTOR = 0.7;
    private static final int CUTOFF = (int)Math.floor(7.516192768E8);

    public static <E> ImmutableSet<E> of() {
        return EmptyImmutableSet.INSTANCE;
    }

    public static <E> ImmutableSet<E> of(E e) {
        return new SingletonImmutableSet<E>(e);
    }

    public static <E> ImmutableSet<E> of(E e, E e2) {
        return ImmutableSet.construct(e, e2);
    }

    public static <E> ImmutableSet<E> of(E e, E e2, E e3) {
        return ImmutableSet.construct(e, e2, e3);
    }

    public static <E> ImmutableSet<E> of(E e, E e2, E e3, E e4) {
        return ImmutableSet.construct(e, e2, e3, e4);
    }

    public static <E> ImmutableSet<E> of(E e, E e2, E e3, E e4, E e5) {
        return ImmutableSet.construct(e, e2, e3, e4, e5);
    }

    public static <E> ImmutableSet<E> of(E e, E e2, E e3, E e4, E e5, E e6, E ... EArray) {
        Object[] objectArray = new Object[6 + EArray.length];
        objectArray[0] = e;
        objectArray[1] = e2;
        objectArray[2] = e3;
        objectArray[3] = e4;
        objectArray[4] = e5;
        objectArray[5] = e6;
        for (int i = 6; i < objectArray.length; ++i) {
            objectArray[i] = EArray[i - 6];
        }
        return ImmutableSet.construct(objectArray);
    }

    private static <E> ImmutableSet<E> construct(Object ... objectArray) {
        Object[] objectArray2;
        Object object;
        int n = ImmutableSet.chooseTableSize(objectArray.length);
        Object[] objectArray3 = new Object[n];
        int n2 = n - 1;
        ArrayList<Object> arrayList = null;
        int n3 = 0;
        block0: for (int i = 0; i < objectArray.length; ++i) {
            object = objectArray[i];
            int n4 = object.hashCode();
            int n5 = Hashing.smear(n4);
            while (true) {
                int n6;
                Object object2;
                if ((object2 = objectArray3[n6 = n5 & n2]) == null) {
                    if (arrayList != null) {
                        arrayList.add(object);
                    }
                    objectArray3[n6] = object;
                    n3 += n4;
                    continue block0;
                }
                if (object2.equals(object)) {
                    if (arrayList != null) continue block0;
                    arrayList = new ArrayList<Object>(objectArray.length);
                    for (int j = 0; j < i; ++j) {
                        Object object3 = objectArray[j];
                        arrayList.add(object3);
                    }
                    continue block0;
                }
                ++n5;
            }
        }
        Object[] objectArray4 = objectArray2 = arrayList == null ? objectArray : arrayList.toArray();
        if (objectArray2.length == 1) {
            object = objectArray2[0];
            return new SingletonImmutableSet<Object>(object, n3);
        }
        if (n != ImmutableSet.chooseTableSize(objectArray2.length)) {
            return ImmutableSet.construct(objectArray2);
        }
        return new RegularImmutableSet(objectArray2, n3, objectArray3, n2);
    }

    @VisibleForTesting
    static int chooseTableSize(int n) {
        if (n < CUTOFF) {
            int n2 = Integer.highestOneBit(n - 1) << 1;
            while ((double)n2 * 0.7 < (double)n) {
                n2 <<= 1;
            }
            return n2;
        }
        Preconditions.checkArgument(n < 0x40000000, "collection too large");
        return 0x40000000;
    }

    public static <E> ImmutableSet<E> copyOf(E[] EArray) {
        switch (EArray.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(EArray[0]);
            }
        }
        return ImmutableSet.construct((Object[])EArray.clone());
    }

    public static <E> ImmutableSet<E> copyOf(Iterable<? extends E> iterable) {
        return iterable instanceof Collection ? ImmutableSet.copyOf(Collections2.cast(iterable)) : ImmutableSet.copyOf(iterable.iterator());
    }

    public static <E> ImmutableSet<E> copyOf(Iterator<? extends E> iterator) {
        return ImmutableSet.copyFromCollection(Lists.newArrayList(iterator));
    }

    public static <E> ImmutableSet<E> copyOf(Collection<? extends E> collection) {
        ImmutableSet immutableSet;
        if (collection instanceof ImmutableSet && !(collection instanceof ImmutableSortedSet) && !(immutableSet = (ImmutableSet)collection).isPartialView()) {
            return immutableSet;
        }
        return ImmutableSet.copyFromCollection(collection);
    }

    private static <E> ImmutableSet<E> copyFromCollection(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        switch (objectArray.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                Object object = objectArray[0];
                return ImmutableSet.of(object);
            }
        }
        return ImmutableSet.construct(objectArray);
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static class Builder<E>
    extends ImmutableCollection.Builder<E> {
        final ArrayList<E> contents = Lists.newArrayList();

        @Override
        public Builder<E> add(E e) {
            this.contents.add(Preconditions.checkNotNull(e));
            return this;
        }

        @Override
        public Builder<E> add(E ... EArray) {
            this.contents.ensureCapacity(this.contents.size() + EArray.length);
            super.add(EArray);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> iterable) {
            if (iterable instanceof Collection) {
                Collection collection = (Collection)iterable;
                this.contents.ensureCapacity(this.contents.size() + collection.size());
            }
            super.addAll(iterable);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> iterator) {
            super.addAll(iterator);
            return this;
        }

        @Override
        public ImmutableSet<E> build() {
            return ImmutableSet.copyOf(this.contents);
        }
    }

    private static class SerializedForm
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        SerializedForm(Object[] objectArray) {
            this.elements = objectArray;
        }

        Object readResolve() {
            return ImmutableSet.copyOf(this.elements);
        }
    }

    static abstract class TransformedImmutableSet<D, E>
    extends ImmutableSet<E> {
        final D[] source;
        final int hashCode;

        TransformedImmutableSet(D[] DArray, int n) {
            this.source = DArray;
            this.hashCode = n;
        }

        abstract E transform(D var1);

        @Override
        public int size() {
            return this.source.length;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return new AbstractIndexedListIterator<E>(this.source.length){

                @Override
                protected E get(int n) {
                    return TransformedImmutableSet.this.transform(TransformedImmutableSet.this.source[n]);
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            int n = this.size();
            if (TArray.length < n) {
                TArray = ObjectArrays.newArray(TArray, n);
            } else if (TArray.length > n) {
                TArray[n] = null;
            }
            T[] TArray2 = TArray;
            for (int i = 0; i < this.source.length; ++i) {
                TArray2[i] = this.transform(this.source[i]);
            }
            return TArray;
        }

        @Override
        public final int hashCode() {
            return this.hashCode;
        }

        @Override
        boolean isHashCodeFast() {
            return true;
        }
    }

    static abstract class ArrayImmutableSet<E>
    extends ImmutableSet<E> {
        final transient Object[] elements;

        ArrayImmutableSet(Object[] objectArray) {
            this.elements = objectArray;
        }

        @Override
        public int size() {
            return this.elements.length;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return Iterators.forArray(this.elements);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            System.arraycopy(this.elements, 0, objectArray, 0, this.size());
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            int n = this.size();
            if (TArray.length < n) {
                TArray = ObjectArrays.newArray(TArray, n);
            } else if (TArray.length > n) {
                TArray[n] = null;
            }
            System.arraycopy(this.elements, 0, TArray, 0, n);
            return TArray;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            if (collection == this) {
                return true;
            }
            if (!(collection instanceof ArrayImmutableSet)) {
                return super.containsAll(collection);
            }
            if (collection.size() > this.size()) {
                return false;
            }
            for (Object object : ((ArrayImmutableSet)collection).elements) {
                if (this.contains(object)) continue;
                return false;
            }
            return true;
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        ImmutableList<E> createAsList() {
            return new ImmutableAsList(this.elements, this);
        }
    }
}

