/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.EmptyImmutableList;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Lists;
import com.google.common.collect.RegularImmutableList;
import com.google.common.collect.SingletonImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.UnmodifiableListIterator;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableList<E>
extends ImmutableCollection<E>
implements List<E>,
RandomAccess {
    public static <E> ImmutableList<E> of() {
        return EmptyImmutableList.INSTANCE;
    }

    public static <E> ImmutableList<E> of(E e) {
        return new SingletonImmutableList<E>(e);
    }

    public static <E> ImmutableList<E> of(E e, E e2) {
        return ImmutableList.construct(e, e2);
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3) {
        return ImmutableList.construct(e, e2, e3);
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4) {
        return ImmutableList.construct(e, e2, e3, e4);
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4, E e5) {
        return ImmutableList.construct(e, e2, e3, e4, e5);
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4, E e5, E e6) {
        return ImmutableList.construct(e, e2, e3, e4, e5, e6);
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4, E e5, E e6, E e7) {
        return ImmutableList.construct(e, e2, e3, e4, e5, e6, e7);
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4, E e5, E e6, E e7, E e8) {
        return ImmutableList.construct(e, e2, e3, e4, e5, e6, e7, e8);
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9) {
        return ImmutableList.construct(e, e2, e3, e4, e5, e6, e7, e8, e9);
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10) {
        return ImmutableList.construct(e, e2, e3, e4, e5, e6, e7, e8, e9, e10);
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10, E e11) {
        return ImmutableList.construct(e, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11);
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10, E e11, E e12, E ... EArray) {
        Object[] objectArray = new Object[12 + EArray.length];
        objectArray[0] = e;
        objectArray[1] = e2;
        objectArray[2] = e3;
        objectArray[3] = e4;
        objectArray[4] = e5;
        objectArray[5] = e6;
        objectArray[6] = e7;
        objectArray[7] = e8;
        objectArray[8] = e9;
        objectArray[9] = e10;
        objectArray[10] = e11;
        objectArray[11] = e12;
        System.arraycopy(EArray, 0, objectArray, 12, EArray.length);
        return ImmutableList.construct(objectArray);
    }

    public static <E> ImmutableList<E> copyOf(Iterable<? extends E> iterable) {
        Preconditions.checkNotNull(iterable);
        return iterable instanceof Collection ? ImmutableList.copyOf(Collections2.cast(iterable)) : ImmutableList.copyOf(iterable.iterator());
    }

    public static <E> ImmutableList<E> copyOf(Collection<? extends E> collection) {
        if (collection instanceof ImmutableCollection) {
            ImmutableList immutableList = ((ImmutableCollection)collection).asList();
            return immutableList.isPartialView() ? ImmutableList.copyFromCollection(immutableList) : immutableList;
        }
        return ImmutableList.copyFromCollection(collection);
    }

    public static <E> ImmutableList<E> copyOf(Iterator<? extends E> iterator) {
        return ImmutableList.copyFromCollection(Lists.newArrayList(iterator));
    }

    public static <E> ImmutableList<E> copyOf(E[] EArray) {
        switch (EArray.length) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return new SingletonImmutableList<E>(EArray[0]);
            }
        }
        return ImmutableList.construct((Object[])EArray.clone());
    }

    private static <E> ImmutableList<E> copyFromCollection(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        switch (objectArray.length) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                SingletonImmutableList<Object> singletonImmutableList = new SingletonImmutableList<Object>(objectArray[0]);
                return singletonImmutableList;
            }
        }
        return ImmutableList.construct(objectArray);
    }

    private static <E> ImmutableList<E> construct(Object ... objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            ImmutableList.checkElementNotNull(objectArray[i], i);
        }
        return new RegularImmutableList(objectArray);
    }

    private static Object checkElementNotNull(Object object, int n) {
        if (object == null) {
            throw new NullPointerException("at index " + n);
        }
        return object;
    }

    ImmutableList() {
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public UnmodifiableListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public abstract UnmodifiableListIterator<E> listIterator(int var1);

    @Override
    public abstract int indexOf(@Nullable Object var1);

    @Override
    public abstract int lastIndexOf(@Nullable Object var1);

    @Override
    public abstract ImmutableList<E> subList(int var1, int var2);

    @Override
    public final boolean addAll(int n, Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E set(int n, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void add(int n, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E remove(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableList<E> asList() {
        return this;
    }

    public ImmutableList<E> reverse() {
        return new ReverseImmutableList(this);
    }

    @Override
    public boolean equals(Object object) {
        return Lists.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return Lists.hashCodeImpl(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static final class Builder<E>
    extends ImmutableCollection.Builder<E> {
        private final ArrayList<E> contents = Lists.newArrayList();

        @Override
        public Builder<E> add(E e) {
            this.contents.add(Preconditions.checkNotNull(e));
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> iterable) {
            if (iterable instanceof Collection) {
                Collection collection = (Collection)iterable;
                this.contents.ensureCapacity(this.contents.size() + collection.size());
            }
            super.addAll(iterable);
            return this;
        }

        @Override
        public Builder<E> add(E ... EArray) {
            this.contents.ensureCapacity(this.contents.size() + EArray.length);
            super.add(EArray);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> iterator) {
            super.addAll(iterator);
            return this;
        }

        @Override
        public ImmutableList<E> build() {
            return ImmutableList.copyOf(this.contents);
        }
    }

    private static class SerializedForm
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        SerializedForm(Object[] objectArray) {
            this.elements = objectArray;
        }

        Object readResolve() {
            return ImmutableList.copyOf(this.elements);
        }
    }

    private static class ReverseImmutableList<E>
    extends ImmutableList<E> {
        private final transient ImmutableList<E> forwardList;
        private final transient int size;

        ReverseImmutableList(ImmutableList<E> immutableList) {
            this.forwardList = immutableList;
            this.size = immutableList.size();
        }

        private int reverseIndex(int n) {
            return this.size - 1 - n;
        }

        private int reversePosition(int n) {
            return this.size - n;
        }

        @Override
        public ImmutableList<E> reverse() {
            return this.forwardList;
        }

        @Override
        public boolean contains(@Nullable Object object) {
            return this.forwardList.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.forwardList.containsAll(collection);
        }

        @Override
        public int indexOf(@Nullable Object object) {
            int n = this.forwardList.lastIndexOf(object);
            return n >= 0 ? this.reverseIndex(n) : -1;
        }

        @Override
        public int lastIndexOf(@Nullable Object object) {
            int n = this.forwardList.indexOf(object);
            return n >= 0 ? this.reverseIndex(n) : -1;
        }

        @Override
        public ImmutableList<E> subList(int n, int n2) {
            Preconditions.checkPositionIndexes(n, n2, this.size);
            return ((ImmutableList)this.forwardList.subList(this.reversePosition(n2), this.reversePosition(n))).reverse();
        }

        @Override
        public E get(int n) {
            Preconditions.checkElementIndex(n, this.size);
            return this.forwardList.get(this.reverseIndex(n));
        }

        @Override
        public UnmodifiableListIterator<E> listIterator(int n) {
            Preconditions.checkPositionIndex(n, this.size);
            ListIterator listIterator = this.forwardList.listIterator(this.reversePosition(n));
            return new UnmodifiableListIterator<E>((UnmodifiableListIterator)listIterator){
                final /* synthetic */ UnmodifiableListIterator val$forward;
                {
                    this.val$forward = unmodifiableListIterator;
                }

                @Override
                public boolean hasNext() {
                    return this.val$forward.hasPrevious();
                }

                @Override
                public boolean hasPrevious() {
                    return this.val$forward.hasNext();
                }

                @Override
                public E next() {
                    return this.val$forward.previous();
                }

                @Override
                public int nextIndex() {
                    return ReverseImmutableList.this.reverseIndex(this.val$forward.previousIndex());
                }

                @Override
                public E previous() {
                    return this.val$forward.next();
                }

                @Override
                public int previousIndex() {
                    return ReverseImmutableList.this.reverseIndex(this.val$forward.nextIndex());
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.forwardList.isEmpty();
        }

        @Override
        boolean isPartialView() {
            return this.forwardList.isPartialView();
        }
    }
}

