/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.RegularImmutableBiMap;
import java.util.Map;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableBiMap<K, V>
extends ImmutableMap<K, V>
implements BiMap<K, V> {
    private static final ImmutableBiMap<Object, Object> EMPTY_IMMUTABLE_BIMAP = new EmptyBiMap();

    public static <K, V> ImmutableBiMap<K, V> of() {
        return EMPTY_IMMUTABLE_BIMAP;
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k, V v) {
        return new RegularImmutableBiMap<K, V>(ImmutableMap.of(k, v));
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k, V v, K k2, V v2) {
        return new RegularImmutableBiMap<K, V>(ImmutableMap.of(k, v, k2, v2));
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3) {
        return new RegularImmutableBiMap<K, V>(ImmutableMap.of(k, v, k2, v2, k3, v3));
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4) {
        return new RegularImmutableBiMap<K, V>(ImmutableMap.of(k, v, k2, v2, k3, v3, k4, v4));
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return new RegularImmutableBiMap<K, V>(ImmutableMap.of(k, v, k2, v2, k3, v3, k4, v4, k5, v5));
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> ImmutableBiMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        ImmutableMap immutableMap;
        if (map instanceof ImmutableBiMap && !(immutableMap = (ImmutableBiMap)map).isPartialView()) {
            return immutableMap;
        }
        if (map.isEmpty()) {
            return ImmutableBiMap.of();
        }
        immutableMap = ImmutableMap.copyOf(map);
        return new RegularImmutableBiMap(immutableMap);
    }

    ImmutableBiMap() {
    }

    abstract ImmutableMap<K, V> delegate();

    @Override
    public abstract ImmutableBiMap<V, K> inverse();

    @Override
    public boolean containsKey(@Nullable Object object) {
        return this.delegate().containsKey(object);
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        return ((ImmutableBiMap)this.inverse()).containsKey(object);
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        return this.delegate().entrySet();
    }

    @Override
    public V get(@Nullable Object object) {
        return this.delegate().get(object);
    }

    @Override
    public ImmutableSet<K> keySet() {
        return this.delegate().keySet();
    }

    @Override
    public ImmutableSet<V> values() {
        return ((ImmutableBiMap)this.inverse()).keySet();
    }

    @Override
    public V forcePut(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate().isEmpty();
    }

    @Override
    public int size() {
        return this.delegate().size();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return object == this || this.delegate().equals(object);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    @Override
    public String toString() {
        return this.delegate().toString();
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this);
    }

    private static class SerializedForm
    extends ImmutableMap.SerializedForm {
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableBiMap<?, ?> immutableBiMap) {
            super(immutableBiMap);
        }

        @Override
        Object readResolve() {
            Builder<Object, Object> builder = new Builder<Object, Object>();
            return this.createMap(builder);
        }
    }

    static class EmptyBiMap
    extends ImmutableBiMap<Object, Object> {
        EmptyBiMap() {
        }

        @Override
        ImmutableMap<Object, Object> delegate() {
            return ImmutableMap.of();
        }

        @Override
        public ImmutableBiMap<Object, Object> inverse() {
            return this;
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        Object readResolve() {
            return EMPTY_IMMUTABLE_BIMAP;
        }
    }

    public static final class Builder<K, V>
    extends ImmutableMap.Builder<K, V> {
        @Override
        public Builder<K, V> put(K k, V v) {
            super.put(k, v);
            return this;
        }

        @Override
        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            super.putAll(map);
            return this;
        }

        @Override
        public ImmutableBiMap<K, V> build() {
            ImmutableMap immutableMap = super.build();
            if (immutableMap.isEmpty()) {
                return ImmutableBiMap.of();
            }
            return new RegularImmutableBiMap(immutableMap);
        }
    }
}

