/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.BstAggregate;
import com.google.common.collect.BstBalancePolicy;
import com.google.common.collect.BstNode;
import com.google.common.collect.BstNodeFactory;
import com.google.common.collect.BstPath;
import com.google.common.collect.BstPathFactory;
import com.google.common.collect.BstSide;
import com.google.common.collect.GeneralRange;
import javax.annotation.Nullable;

@GwtCompatible
final class BstRangeOps {
    public static <K, N extends BstNode<K, N>> long totalInRange(BstAggregate<? super N> bstAggregate, GeneralRange<K> generalRange, @Nullable N n) {
        Preconditions.checkNotNull(bstAggregate);
        Preconditions.checkNotNull(generalRange);
        if (n == null || generalRange.isEmpty()) {
            return 0L;
        }
        long l = bstAggregate.treeValue(n);
        if (generalRange.hasLowerBound()) {
            l -= BstRangeOps.totalBeyondRangeToSide(bstAggregate, generalRange, BstSide.LEFT, n);
        }
        if (generalRange.hasUpperBound()) {
            l -= BstRangeOps.totalBeyondRangeToSide(bstAggregate, generalRange, BstSide.RIGHT, n);
        }
        return l;
    }

    private static <K, N extends BstNode<K, N>> long totalBeyondRangeToSide(BstAggregate<? super N> bstAggregate, GeneralRange<K> generalRange, BstSide bstSide, @Nullable N n) {
        long l = 0L;
        while (n != null) {
            if (BstRangeOps.beyond(generalRange, n.getKey(), bstSide)) {
                l += (long)bstAggregate.entryValue(n);
                l += bstAggregate.treeValue(n.childOrNull(bstSide));
                n = n.childOrNull(bstSide.other());
                continue;
            }
            n = n.childOrNull(bstSide);
        }
        return l;
    }

    @Nullable
    public static <K, N extends BstNode<K, N>> N minusRange(GeneralRange<K> generalRange, BstBalancePolicy<N> bstBalancePolicy, BstNodeFactory<N> bstNodeFactory, @Nullable N n) {
        Preconditions.checkNotNull(generalRange);
        Preconditions.checkNotNull(bstBalancePolicy);
        Preconditions.checkNotNull(bstNodeFactory);
        Object n2 = generalRange.hasUpperBound() ? (Object)BstRangeOps.subTreeBeyondRangeToSide(generalRange, bstBalancePolicy, bstNodeFactory, BstSide.RIGHT, n) : null;
        Object n3 = generalRange.hasLowerBound() ? (Object)BstRangeOps.subTreeBeyondRangeToSide(generalRange, bstBalancePolicy, bstNodeFactory, BstSide.LEFT, n) : null;
        return bstBalancePolicy.combine(bstNodeFactory, n3, n2);
    }

    @Nullable
    private static <K, N extends BstNode<K, N>> N subTreeBeyondRangeToSide(GeneralRange<K> generalRange, BstBalancePolicy<N> bstBalancePolicy, BstNodeFactory<N> bstNodeFactory, BstSide bstSide, @Nullable N n) {
        if (n == null) {
            return null;
        }
        if (BstRangeOps.beyond(generalRange, n.getKey(), bstSide)) {
            N n2 = n.childOrNull(BstSide.LEFT);
            N n3 = n.childOrNull(BstSide.RIGHT);
            switch (bstSide) {
                case LEFT: {
                    n3 = BstRangeOps.subTreeBeyondRangeToSide(generalRange, bstBalancePolicy, bstNodeFactory, BstSide.LEFT, n3);
                    break;
                }
                case RIGHT: {
                    n2 = BstRangeOps.subTreeBeyondRangeToSide(generalRange, bstBalancePolicy, bstNodeFactory, BstSide.RIGHT, n2);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return bstBalancePolicy.balance(bstNodeFactory, n, n2, n3);
        }
        return BstRangeOps.subTreeBeyondRangeToSide(generalRange, bstBalancePolicy, bstNodeFactory, bstSide, n.childOrNull(bstSide));
    }

    @Nullable
    public static <K, N extends BstNode<K, N>, P extends BstPath<N, P>> P furthestPath(GeneralRange<K> generalRange, BstSide bstSide, BstPathFactory<N, P> bstPathFactory, @Nullable N n) {
        Preconditions.checkNotNull(generalRange);
        Preconditions.checkNotNull(bstPathFactory);
        Preconditions.checkNotNull(bstSide);
        if (n == null) {
            return null;
        }
        P p = bstPathFactory.initialPath(n);
        return BstRangeOps.furthestPath(generalRange, bstSide, bstPathFactory, p);
    }

    private static <K, N extends BstNode<K, N>, P extends BstPath<N, P>> P furthestPath(GeneralRange<K> generalRange, BstSide bstSide, BstPathFactory<N, P> bstPathFactory, P p) {
        N n = p.getTip();
        K k = ((BstNode)n).getKey();
        if (BstRangeOps.beyond(generalRange, k, bstSide)) {
            if (((BstNode)n).hasChild(bstSide.other())) {
                p = bstPathFactory.extension(p, bstSide.other());
                return BstRangeOps.furthestPath(generalRange, bstSide, bstPathFactory, p);
            }
            return null;
        }
        if (((BstNode)n).hasChild(bstSide)) {
            P p2 = bstPathFactory.extension(p, bstSide);
            if ((p2 = BstRangeOps.furthestPath(generalRange, bstSide, bstPathFactory, p2)) != null) {
                return p2;
            }
        }
        return BstRangeOps.beyond(generalRange, k, bstSide.other()) ? null : (P)p;
    }

    public static <K> boolean beyond(GeneralRange<K> generalRange, @Nullable K k, BstSide bstSide) {
        Preconditions.checkNotNull(generalRange);
        switch (bstSide) {
            case LEFT: {
                return generalRange.tooLow(k);
            }
            case RIGHT: {
                return generalRange.tooHigh(k);
            }
        }
        throw new AssertionError();
    }

    private BstRangeOps() {
    }
}

