/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.BstBalancePolicy;
import com.google.common.collect.BstInOrderPath;
import com.google.common.collect.BstModificationResult;
import com.google.common.collect.BstModifier;
import com.google.common.collect.BstMutationResult;
import com.google.common.collect.BstMutationRule;
import com.google.common.collect.BstNode;
import com.google.common.collect.BstNodeFactory;
import com.google.common.collect.BstSide;
import java.util.Comparator;
import javax.annotation.Nullable;

@GwtCompatible
final class BstOperations {
    private BstOperations() {
    }

    @Nullable
    public static <K, N extends BstNode<K, N>> N seek(Comparator<? super K> comparator, @Nullable N n, @Nullable K k) {
        Preconditions.checkNotNull(comparator);
        if (n == null) {
            return null;
        }
        int n2 = comparator.compare(k, n.getKey());
        if (n2 == 0) {
            return n;
        }
        BstSide bstSide = n2 < 0 ? BstSide.LEFT : BstSide.RIGHT;
        return BstOperations.seek(comparator, n.childOrNull(bstSide), k);
    }

    public static <K, N extends BstNode<K, N>> BstMutationResult<K, N> mutate(Comparator<? super K> comparator, BstMutationRule<K, N> bstMutationRule, @Nullable N n, @Nullable K k) {
        int n2;
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(bstMutationRule);
        if (n != null && (n2 = comparator.compare(k, n.getKey())) != 0) {
            BstSide bstSide = n2 < 0 ? BstSide.LEFT : BstSide.RIGHT;
            BstMutationResult<K, N> bstMutationResult = BstOperations.mutate(comparator, bstMutationRule, n.childOrNull(bstSide), k);
            return bstMutationResult.lift(n, bstSide, bstMutationRule.getNodeFactory(), bstMutationRule.getBalancePolicy());
        }
        return BstOperations.modify(n, k, bstMutationRule);
    }

    public static <K, N extends BstNode<K, N>> BstMutationResult<K, N> mutate(BstInOrderPath<N> bstInOrderPath, BstMutationRule<K, N> bstMutationRule) {
        Preconditions.checkNotNull(bstInOrderPath);
        Preconditions.checkNotNull(bstMutationRule);
        BstBalancePolicy<N> bstBalancePolicy = bstMutationRule.getBalancePolicy();
        BstNodeFactory<N> bstNodeFactory = bstMutationRule.getNodeFactory();
        Object n = bstInOrderPath.getTip();
        K k = ((BstNode)n).getKey();
        BstMutationResult bstMutationResult = BstOperations.modify(n, k, bstMutationRule);
        while (bstInOrderPath.hasPrefix()) {
            BstInOrderPath bstInOrderPath2 = (BstInOrderPath)bstInOrderPath.getPrefix();
            bstMutationResult = bstMutationResult.lift(bstInOrderPath2.getTip(), bstInOrderPath.getSideOfExtension(), bstNodeFactory, bstBalancePolicy);
            bstInOrderPath = bstInOrderPath2;
        }
        return bstMutationResult;
    }

    private static <K, N extends BstNode<K, N>> BstMutationResult<K, N> modify(@Nullable N n, K k, BstMutationRule<K, N> bstMutationRule) {
        N n2;
        BstBalancePolicy<Object> bstBalancePolicy = bstMutationRule.getBalancePolicy();
        BstNodeFactory<Object> bstNodeFactory = bstMutationRule.getNodeFactory();
        BstModifier<K, Object> bstModifier = bstMutationRule.getModifier();
        N n3 = n;
        Object n4 = n == null ? null : (Object)bstNodeFactory.createLeaf(n);
        BstModificationResult<Object> bstModificationResult = bstModifier.modify(k, n4);
        Object n5 = null;
        Object n6 = null;
        if (n != null) {
            n5 = n.childOrNull(BstSide.LEFT);
            n6 = n.childOrNull(BstSide.RIGHT);
        }
        switch (bstModificationResult.getType()) {
            case IDENTITY: {
                n2 = n;
                break;
            }
            case REBUILDING_CHANGE: {
                if (bstModificationResult.getChangedTarget() != null) {
                    n2 = bstNodeFactory.createNode(bstModificationResult.getChangedTarget(), n5, n6);
                    break;
                }
                if (n == null) {
                    n2 = null;
                    break;
                }
                throw new AssertionError((Object)"Modification result is a REBUILDING_CHANGE, but rebalancing required");
            }
            case REBALANCING_CHANGE: {
                if (bstModificationResult.getChangedTarget() != null) {
                    n2 = bstBalancePolicy.balance(bstNodeFactory, bstModificationResult.getChangedTarget(), n5, n6);
                    break;
                }
                if (n != null) {
                    n2 = bstBalancePolicy.combine(bstNodeFactory, n5, n6);
                    break;
                }
                n2 = null;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return BstMutationResult.mutationResult(k, n3, n2, bstModificationResult);
    }

    public static <K, N extends BstNode<K, N>> BstMutationResult<K, N> extractMin(N n, BstNodeFactory<N> bstNodeFactory, BstBalancePolicy<N> bstBalancePolicy) {
        Preconditions.checkNotNull(n);
        Preconditions.checkNotNull(bstNodeFactory);
        Preconditions.checkNotNull(bstBalancePolicy);
        if (n.hasChild(BstSide.LEFT)) {
            BstMutationResult<K, N> bstMutationResult = BstOperations.extractMin(n.getChild(BstSide.LEFT), bstNodeFactory, bstBalancePolicy);
            return bstMutationResult.lift(n, BstSide.LEFT, bstNodeFactory, bstBalancePolicy);
        }
        return BstMutationResult.mutationResult(n.getKey(), n, n.childOrNull(BstSide.RIGHT), BstModificationResult.rebalancingChange(n, null));
    }

    public static <K, N extends BstNode<K, N>> BstMutationResult<K, N> extractMax(N n, BstNodeFactory<N> bstNodeFactory, BstBalancePolicy<N> bstBalancePolicy) {
        Preconditions.checkNotNull(n);
        Preconditions.checkNotNull(bstNodeFactory);
        Preconditions.checkNotNull(bstBalancePolicy);
        if (n.hasChild(BstSide.RIGHT)) {
            BstMutationResult<K, N> bstMutationResult = BstOperations.extractMax(n.getChild(BstSide.RIGHT), bstNodeFactory, bstBalancePolicy);
            return bstMutationResult.lift(n, BstSide.RIGHT, bstNodeFactory, bstBalancePolicy);
        }
        return BstMutationResult.mutationResult(n.getKey(), n, n.childOrNull(BstSide.LEFT), BstModificationResult.rebalancingChange(n, null));
    }

    public static <N extends BstNode<?, N>> N insertMin(@Nullable N n, N n2, BstNodeFactory<N> bstNodeFactory, BstBalancePolicy<N> bstBalancePolicy) {
        Preconditions.checkNotNull(n2);
        Preconditions.checkNotNull(bstNodeFactory);
        Preconditions.checkNotNull(bstBalancePolicy);
        if (n == null) {
            return bstNodeFactory.createLeaf(n2);
        }
        return bstBalancePolicy.balance(bstNodeFactory, n, BstOperations.insertMin(n.childOrNull(BstSide.LEFT), n2, bstNodeFactory, bstBalancePolicy), n.childOrNull(BstSide.RIGHT));
    }

    public static <N extends BstNode<?, N>> N insertMax(@Nullable N n, N n2, BstNodeFactory<N> bstNodeFactory, BstBalancePolicy<N> bstBalancePolicy) {
        Preconditions.checkNotNull(n2);
        Preconditions.checkNotNull(bstNodeFactory);
        Preconditions.checkNotNull(bstBalancePolicy);
        if (n == null) {
            return bstNodeFactory.createLeaf(n2);
        }
        return bstBalancePolicy.balance(bstNodeFactory, n, n.childOrNull(BstSide.LEFT), BstOperations.insertMax(n.childOrNull(BstSide.RIGHT), n2, bstNodeFactory, bstBalancePolicy));
    }
}

