/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.BstSide;
import java.util.Comparator;
import javax.annotation.Nullable;

@GwtCompatible
class BstNode<K, N extends BstNode<K, N>> {
    private final K key;
    @Nullable
    private final N left;
    @Nullable
    private final N right;

    BstNode(@Nullable K k, @Nullable N n, @Nullable N n2) {
        this.key = k;
        this.left = n;
        this.right = n2;
    }

    @Nullable
    public final K getKey() {
        return this.key;
    }

    @Nullable
    public final N childOrNull(BstSide bstSide) {
        switch (bstSide) {
            case LEFT: {
                return this.left;
            }
            case RIGHT: {
                return this.right;
            }
        }
        throw new AssertionError();
    }

    public final boolean hasChild(BstSide bstSide) {
        return this.childOrNull(bstSide) != null;
    }

    public final N getChild(BstSide bstSide) {
        N n = this.childOrNull(bstSide);
        Preconditions.checkState(n != null);
        return n;
    }

    protected final boolean orderingInvariantHolds(Comparator<? super K> comparator) {
        Preconditions.checkNotNull(comparator);
        boolean bl = true;
        if (this.hasChild(BstSide.LEFT)) {
            bl &= comparator.compare(((BstNode)this.getChild(BstSide.LEFT)).getKey(), this.key) < 0;
        }
        if (this.hasChild(BstSide.RIGHT)) {
            bl &= comparator.compare(((BstNode)this.getChild(BstSide.RIGHT)).getKey(), this.key) > 0;
        }
        return bl;
    }
}

