/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.BstNode;
import com.google.common.collect.BstPath;
import com.google.common.collect.BstPathFactory;
import com.google.common.collect.BstSide;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

@GwtCompatible
final class BstInOrderPath<N extends BstNode<?, N>>
extends BstPath<N, BstInOrderPath<N>> {
    private final BstSide sideExtension;
    private transient Optional<BstInOrderPath<N>> prevInOrder;
    private transient Optional<BstInOrderPath<N>> nextInOrder;

    public static <N extends BstNode<?, N>> BstPathFactory<N, BstInOrderPath<N>> inOrderFactory() {
        return new BstPathFactory<N, BstInOrderPath<N>>(){

            @Override
            public BstInOrderPath<N> extension(BstInOrderPath<N> bstInOrderPath, BstSide bstSide) {
                return BstInOrderPath.extension(bstInOrderPath, bstSide);
            }

            @Override
            public BstInOrderPath<N> initialPath(N n) {
                return new BstInOrderPath((BstNode)n, null, null, null);
            }
        };
    }

    private static <N extends BstNode<?, N>> BstInOrderPath<N> extension(BstInOrderPath<N> bstInOrderPath, BstSide bstSide) {
        Preconditions.checkNotNull(bstInOrderPath);
        Object n = bstInOrderPath.getTip();
        return new BstInOrderPath<N>(((BstNode)n).getChild(bstSide), bstSide, bstInOrderPath);
    }

    private BstInOrderPath(N n, @Nullable BstSide bstSide, @Nullable BstInOrderPath<N> bstInOrderPath) {
        super(n, bstInOrderPath);
        this.sideExtension = bstSide;
        assert (bstSide == null == (bstInOrderPath == null));
    }

    private Optional<BstInOrderPath<N>> computeNextInOrder(BstSide bstSide) {
        if (((BstNode)this.getTip()).hasChild(bstSide)) {
            BstInOrderPath<N> bstInOrderPath = BstInOrderPath.extension(this, bstSide);
            BstSide bstSide2 = bstSide.other();
            while (((BstNode)bstInOrderPath.getTip()).hasChild(bstSide2)) {
                bstInOrderPath = BstInOrderPath.extension(bstInOrderPath, bstSide2);
            }
            return Optional.of(bstInOrderPath);
        }
        BstInOrderPath bstInOrderPath = this;
        while (bstInOrderPath.sideExtension == bstSide) {
            bstInOrderPath = (BstInOrderPath)bstInOrderPath.getPrefix();
        }
        bstInOrderPath = (BstInOrderPath)bstInOrderPath.prefixOrNull();
        return Optional.fromNullable(bstInOrderPath);
    }

    private Optional<BstInOrderPath<N>> nextInOrder(BstSide bstSide) {
        switch (bstSide) {
            case LEFT: {
                Optional<BstInOrderPath<N>> optional = this.prevInOrder;
                return optional == null ? (this.prevInOrder = this.computeNextInOrder(bstSide)) : optional;
            }
            case RIGHT: {
                Optional<BstInOrderPath<N>> optional = this.nextInOrder;
                return optional == null ? (this.nextInOrder = this.computeNextInOrder(bstSide)) : optional;
            }
        }
        throw new AssertionError();
    }

    public boolean hasNext(BstSide bstSide) {
        return this.nextInOrder(bstSide).isPresent();
    }

    public BstInOrderPath<N> next(BstSide bstSide) {
        if (!this.hasNext(bstSide)) {
            throw new NoSuchElementException();
        }
        return this.nextInOrder(bstSide).get();
    }

    public BstSide getSideOfExtension() {
        return this.sideExtension;
    }

    /* synthetic */ BstInOrderPath(BstNode bstNode, BstSide bstSide, BstInOrderPath bstInOrderPath, 1 var4_4) {
        this(bstNode, bstSide, bstInOrderPath);
    }
}

