/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.BstAggregate;
import com.google.common.collect.BstBalancePolicy;
import com.google.common.collect.BstMutationResult;
import com.google.common.collect.BstNode;
import com.google.common.collect.BstNodeFactory;
import com.google.common.collect.BstOperations;
import com.google.common.collect.BstSide;
import javax.annotation.Nullable;

@GwtCompatible
final class BstCountBasedBalancePolicies {
    private static final int SINGLE_ROTATE_RATIO = 4;
    private static final int SECOND_ROTATE_RATIO = 2;

    private BstCountBasedBalancePolicies() {
    }

    public static <N extends BstNode<?, N>> BstBalancePolicy<N> noRebalancePolicy(final BstAggregate<N> bstAggregate) {
        Preconditions.checkNotNull(bstAggregate);
        return new BstBalancePolicy<N>(){

            @Override
            public N balance(BstNodeFactory<N> bstNodeFactory, N n, @Nullable N n2, @Nullable N n3) {
                return Preconditions.checkNotNull(bstNodeFactory).createNode(n, n2, n3);
            }

            @Override
            @Nullable
            public N combine(BstNodeFactory<N> bstNodeFactory, @Nullable N n, @Nullable N n2) {
                if (n == null) {
                    return n2;
                }
                if (n2 == null) {
                    return n;
                }
                if (bstAggregate.treeValue(n) > bstAggregate.treeValue(n2)) {
                    return bstNodeFactory.createNode(n, ((BstNode)n).childOrNull(BstSide.LEFT), this.combine(bstNodeFactory, ((BstNode)n).childOrNull(BstSide.RIGHT), n2));
                }
                return bstNodeFactory.createNode(n2, this.combine(bstNodeFactory, n, ((BstNode)n2).childOrNull(BstSide.LEFT)), ((BstNode)n2).childOrNull(BstSide.RIGHT));
            }
        };
    }

    public static <K, N extends BstNode<K, N>> BstBalancePolicy<N> singleRebalancePolicy(final BstAggregate<N> bstAggregate) {
        Preconditions.checkNotNull(bstAggregate);
        return new BstBalancePolicy<N>(){

            @Override
            public N balance(BstNodeFactory<N> bstNodeFactory, N n, @Nullable N n2, @Nullable N n3) {
                long l;
                long l2 = bstAggregate.treeValue(n2);
                if (l2 + (l = bstAggregate.treeValue(n3)) > 1L) {
                    if (l >= 4L * l2) {
                        return this.rotateL(bstNodeFactory, n, n2, n3);
                    }
                    if (l2 >= 4L * l) {
                        return this.rotateR(bstNodeFactory, n, n2, n3);
                    }
                }
                return bstNodeFactory.createNode(n, n2, n3);
            }

            private N rotateL(BstNodeFactory<N> bstNodeFactory, N n, @Nullable N n2, N n3) {
                Preconditions.checkNotNull(n3);
                Object n4 = ((BstNode)n3).childOrNull(BstSide.LEFT);
                Object n5 = ((BstNode)n3).childOrNull(BstSide.RIGHT);
                if (bstAggregate.treeValue(n4) >= 2L * bstAggregate.treeValue(n5)) {
                    n3 = this.singleR(bstNodeFactory, n3, n4, n5);
                }
                return this.singleL(bstNodeFactory, n, n2, n3);
            }

            private N rotateR(BstNodeFactory<N> bstNodeFactory, N n, N n2, @Nullable N n3) {
                Preconditions.checkNotNull(n2);
                Object n4 = ((BstNode)n2).childOrNull(BstSide.RIGHT);
                Object n5 = ((BstNode)n2).childOrNull(BstSide.LEFT);
                if (bstAggregate.treeValue(n4) >= 2L * bstAggregate.treeValue(n5)) {
                    n2 = this.singleL(bstNodeFactory, n2, n5, n4);
                }
                return this.singleR(bstNodeFactory, n, n2, n3);
            }

            private N singleL(BstNodeFactory<N> bstNodeFactory, N n, @Nullable N n2, N n3) {
                Preconditions.checkNotNull(n3);
                return bstNodeFactory.createNode(n3, bstNodeFactory.createNode(n, n2, ((BstNode)n3).childOrNull(BstSide.LEFT)), ((BstNode)n3).childOrNull(BstSide.RIGHT));
            }

            private N singleR(BstNodeFactory<N> bstNodeFactory, N n, N n2, @Nullable N n3) {
                Preconditions.checkNotNull(n2);
                return bstNodeFactory.createNode(n2, ((BstNode)n2).childOrNull(BstSide.LEFT), bstNodeFactory.createNode(n, ((BstNode)n2).childOrNull(BstSide.RIGHT), n3));
            }

            @Override
            @Nullable
            public N combine(BstNodeFactory<N> bstNodeFactory, @Nullable N n, @Nullable N n2) {
                Object n3;
                if (n == null) {
                    return n2;
                }
                if (n2 == null) {
                    return n;
                }
                if (bstAggregate.treeValue(n) > bstAggregate.treeValue(n2)) {
                    BstMutationResult bstMutationResult = BstOperations.extractMax(n, bstNodeFactory, this);
                    n3 = bstMutationResult.getOriginalTarget();
                    n = bstMutationResult.getChangedRoot();
                } else {
                    BstMutationResult bstMutationResult = BstOperations.extractMin(n2, bstNodeFactory, this);
                    n3 = bstMutationResult.getOriginalTarget();
                    n2 = bstMutationResult.getChangedRoot();
                }
                return bstNodeFactory.createNode(n3, n, n2);
            }
        };
    }

    public static <K, N extends BstNode<K, N>> BstBalancePolicy<N> fullRebalancePolicy(final BstAggregate<N> bstAggregate) {
        Preconditions.checkNotNull(bstAggregate);
        final BstBalancePolicy<N> bstBalancePolicy = BstCountBasedBalancePolicies.singleRebalancePolicy(bstAggregate);
        return new BstBalancePolicy<N>(){

            @Override
            public N balance(BstNodeFactory<N> bstNodeFactory, N n, @Nullable N n2, @Nullable N n3) {
                long l;
                if (n2 == null) {
                    return BstOperations.insertMin(n3, n, bstNodeFactory, bstBalancePolicy);
                }
                if (n3 == null) {
                    return BstOperations.insertMax(n2, n, bstNodeFactory, bstBalancePolicy);
                }
                long l2 = bstAggregate.treeValue(n2);
                if (4L * l2 <= (l = bstAggregate.treeValue(n3))) {
                    Object n4 = this.balance(bstNodeFactory, n, n2, ((BstNode)n3).childOrNull(BstSide.LEFT));
                    return bstBalancePolicy.balance(bstNodeFactory, n3, n4, ((BstNode)n3).childOrNull(BstSide.RIGHT));
                }
                if (4L * l <= l2) {
                    Object n5 = this.balance(bstNodeFactory, n, ((BstNode)n2).childOrNull(BstSide.RIGHT), n3);
                    return bstBalancePolicy.balance(bstNodeFactory, n2, ((BstNode)n2).childOrNull(BstSide.LEFT), n5);
                }
                return bstNodeFactory.createNode(n, n2, n3);
            }

            @Override
            @Nullable
            public N combine(BstNodeFactory<N> bstNodeFactory, @Nullable N n, @Nullable N n2) {
                long l;
                if (n == null) {
                    return n2;
                }
                if (n2 == null) {
                    return n;
                }
                long l2 = bstAggregate.treeValue(n);
                if (4L * l2 <= (l = bstAggregate.treeValue(n2))) {
                    Object n3 = this.combine(bstNodeFactory, n, ((BstNode)n2).childOrNull(BstSide.LEFT));
                    return bstBalancePolicy.balance(bstNodeFactory, n2, n3, ((BstNode)n2).childOrNull(BstSide.RIGHT));
                }
                if (4L * l <= l2) {
                    Object n4 = this.combine(bstNodeFactory, ((BstNode)n).childOrNull(BstSide.RIGHT), n2);
                    return bstBalancePolicy.balance(bstNodeFactory, n, ((BstNode)n).childOrNull(BstSide.LEFT), n4);
                }
                return bstBalancePolicy.combine(bstNodeFactory, n, n2);
            }
        };
    }
}

