/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible
final class Present<T>
extends Optional<T> {
    private final T reference;
    private static final long serialVersionUID = 0L;

    Present(T t) {
        this.reference = t;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public T get() {
        return this.reference;
    }

    @Override
    public T or(T t) {
        Preconditions.checkNotNull(t, "use orNull() instead of or(null)");
        return this.reference;
    }

    @Override
    public Optional<T> or(Optional<? extends T> optional) {
        Preconditions.checkNotNull(optional);
        return this;
    }

    @Override
    public T or(Supplier<? extends T> supplier) {
        Preconditions.checkNotNull(supplier);
        return this.reference;
    }

    @Override
    public T orNull() {
        return this.reference;
    }

    @Override
    public Set<T> asSet() {
        return Collections.singleton(this.reference);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof Present) {
            Present present = (Present)object;
            return this.reference.equals(present.reference);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 1502476572 + this.reference.hashCode();
    }

    @Override
    public String toString() {
        return "Optional.of(" + this.reference + ")";
    }
}

