/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

@GwtCompatible
public final class Objects {
    private Objects() {
    }

    public static boolean equal(@Nullable Object object, @Nullable Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static int hashCode(Object ... objectArray) {
        return Arrays.hashCode(objectArray);
    }

    public static ToStringHelper toStringHelper(Object object) {
        return new ToStringHelper(Objects.simpleName(object.getClass()));
    }

    public static ToStringHelper toStringHelper(Class<?> clazz) {
        return new ToStringHelper(Objects.simpleName(clazz));
    }

    public static ToStringHelper toStringHelper(String string) {
        return new ToStringHelper(string);
    }

    private static String simpleName(Class<?> clazz) {
        String string = clazz.getName();
        int n = (string = string.replaceAll("\\$[0-9]+", "\\$")).lastIndexOf(36);
        if (n == -1) {
            n = string.lastIndexOf(46);
        }
        return string.substring(n + 1);
    }

    public static <T> T firstNonNull(@Nullable T t, @Nullable T t2) {
        return t != null ? t : Preconditions.checkNotNull(t2);
    }

    public static final class ToStringHelper {
        private final String className;
        private final List<ValueHolder> valueHolders = new LinkedList<ValueHolder>();
        private boolean omitNullValues = false;

        private ToStringHelper(String string) {
            this.className = Preconditions.checkNotNull(string);
        }

        public ToStringHelper omitNullValues() {
            this.omitNullValues = true;
            return this;
        }

        public ToStringHelper add(String string, @Nullable Object object) {
            Preconditions.checkNotNull(string);
            this.addHolder((Object)object).builder.append(string).append('=').append(object);
            return this;
        }

        public ToStringHelper add(String string, boolean bl) {
            this.checkNameAndAppend(string).append(bl);
            return this;
        }

        public ToStringHelper add(String string, char c) {
            this.checkNameAndAppend(string).append(c);
            return this;
        }

        public ToStringHelper add(String string, double d) {
            this.checkNameAndAppend(string).append(d);
            return this;
        }

        public ToStringHelper add(String string, float f) {
            this.checkNameAndAppend(string).append(f);
            return this;
        }

        public ToStringHelper add(String string, int n) {
            this.checkNameAndAppend(string).append(n);
            return this;
        }

        public ToStringHelper add(String string, long l) {
            this.checkNameAndAppend(string).append(l);
            return this;
        }

        private StringBuilder checkNameAndAppend(String string) {
            Preconditions.checkNotNull(string);
            return this.addHolder().builder.append(string).append('=');
        }

        public ToStringHelper addValue(@Nullable Object object) {
            this.addHolder((Object)object).builder.append(object);
            return this;
        }

        public ToStringHelper addValue(boolean bl) {
            this.addHolder().builder.append(bl);
            return this;
        }

        public ToStringHelper addValue(char c) {
            this.addHolder().builder.append(c);
            return this;
        }

        public ToStringHelper addValue(double d) {
            this.addHolder().builder.append(d);
            return this;
        }

        public ToStringHelper addValue(float f) {
            this.addHolder().builder.append(f);
            return this;
        }

        public ToStringHelper addValue(int n) {
            this.addHolder().builder.append(n);
            return this;
        }

        public ToStringHelper addValue(long l) {
            this.addHolder().builder.append(l);
            return this;
        }

        public String toString() {
            boolean bl = this.omitNullValues;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder(32).append(this.className).append('{');
            for (ValueHolder valueHolder : this.valueHolders) {
                if (bl && valueHolder.isNull) continue;
                if (bl2) {
                    stringBuilder.append(", ");
                } else {
                    bl2 = true;
                }
                StringBuilder stringBuilder2 = valueHolder.builder;
                stringBuilder.append((CharSequence)stringBuilder2);
            }
            return stringBuilder.append('}').toString();
        }

        private ValueHolder addHolder() {
            ValueHolder valueHolder = new ValueHolder();
            this.valueHolders.add(valueHolder);
            return valueHolder;
        }

        private ValueHolder addHolder(@Nullable Object object) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.isNull = object == null;
            return valueHolder;
        }

        private static final class ValueHolder {
            final StringBuilder builder = new StringBuilder();
            boolean isNull;

            private ValueHolder() {
            }
        }
    }
}

