/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;

@GwtCompatible
public final class Functions {
    private Functions() {
    }

    public static Function<Object, String> toStringFunction() {
        return ToStringFunction.INSTANCE;
    }

    public static <E> Function<E, E> identity() {
        return IdentityFunction.INSTANCE;
    }

    public static <K, V> Function<K, V> forMap(Map<K, V> map) {
        return new FunctionForMapNoDefault<K, V>(map);
    }

    public static <K, V> Function<K, V> forMap(Map<K, ? extends V> map, @Nullable V v) {
        return new ForMapWithDefault<K, V>(map, v);
    }

    public static <A, B, C> Function<A, C> compose(Function<B, C> function, Function<A, ? extends B> function2) {
        return new FunctionComposition<A, B, C>(function, function2);
    }

    public static <T> Function<T, Boolean> forPredicate(Predicate<T> predicate) {
        return new PredicateFunction(predicate);
    }

    public static <E> Function<Object, E> constant(@Nullable E e) {
        return new ConstantFunction<E>(e);
    }

    @Beta
    public static <T> Function<Object, T> forSupplier(Supplier<T> supplier) {
        return new SupplierFunction(supplier);
    }

    private static class SupplierFunction<T>
    implements Function<Object, T>,
    Serializable {
        private final Supplier<T> supplier;
        private static final long serialVersionUID = 0L;

        private SupplierFunction(Supplier<T> supplier) {
            this.supplier = Preconditions.checkNotNull(supplier);
        }

        @Override
        public T apply(@Nullable Object object) {
            return this.supplier.get();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof SupplierFunction) {
                SupplierFunction supplierFunction = (SupplierFunction)object;
                return this.supplier.equals(supplierFunction.supplier);
            }
            return false;
        }

        public int hashCode() {
            return this.supplier.hashCode();
        }

        public String toString() {
            return "forSupplier(" + this.supplier + ")";
        }
    }

    private static class ConstantFunction<E>
    implements Function<Object, E>,
    Serializable {
        private final E value;
        private static final long serialVersionUID = 0L;

        public ConstantFunction(@Nullable E e) {
            this.value = e;
        }

        @Override
        public E apply(@Nullable Object object) {
            return this.value;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof ConstantFunction) {
                ConstantFunction constantFunction = (ConstantFunction)object;
                return Objects.equal(this.value, constantFunction.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        public String toString() {
            return "constant(" + this.value + ")";
        }
    }

    private static class PredicateFunction<T>
    implements Function<T, Boolean>,
    Serializable {
        private final Predicate<T> predicate;
        private static final long serialVersionUID = 0L;

        private PredicateFunction(Predicate<T> predicate) {
            this.predicate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public Boolean apply(T t) {
            return this.predicate.apply(t);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof PredicateFunction) {
                PredicateFunction predicateFunction = (PredicateFunction)object;
                return this.predicate.equals(predicateFunction.predicate);
            }
            return false;
        }

        public int hashCode() {
            return this.predicate.hashCode();
        }

        public String toString() {
            return "forPredicate(" + this.predicate + ")";
        }
    }

    private static class FunctionComposition<A, B, C>
    implements Function<A, C>,
    Serializable {
        private final Function<B, C> g;
        private final Function<A, ? extends B> f;
        private static final long serialVersionUID = 0L;

        public FunctionComposition(Function<B, C> function, Function<A, ? extends B> function2) {
            this.g = Preconditions.checkNotNull(function);
            this.f = Preconditions.checkNotNull(function2);
        }

        @Override
        public C apply(A a) {
            return this.g.apply(this.f.apply(a));
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof FunctionComposition) {
                FunctionComposition functionComposition = (FunctionComposition)object;
                return this.f.equals(functionComposition.f) && this.g.equals(functionComposition.g);
            }
            return false;
        }

        public int hashCode() {
            return this.f.hashCode() ^ this.g.hashCode();
        }

        public String toString() {
            return this.g.toString() + "(" + this.f.toString() + ")";
        }
    }

    private static class ForMapWithDefault<K, V>
    implements Function<K, V>,
    Serializable {
        final Map<K, ? extends V> map;
        final V defaultValue;
        private static final long serialVersionUID = 0L;

        ForMapWithDefault(Map<K, ? extends V> map, @Nullable V v) {
            this.map = Preconditions.checkNotNull(map);
            this.defaultValue = v;
        }

        @Override
        public V apply(K k) {
            V v = this.map.get(k);
            return v != null || this.map.containsKey(k) ? v : this.defaultValue;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof ForMapWithDefault) {
                ForMapWithDefault forMapWithDefault = (ForMapWithDefault)object;
                return this.map.equals(forMapWithDefault.map) && Objects.equal(this.defaultValue, forMapWithDefault.defaultValue);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.map, this.defaultValue);
        }

        public String toString() {
            return "forMap(" + this.map + ", defaultValue=" + this.defaultValue + ")";
        }
    }

    private static class FunctionForMapNoDefault<K, V>
    implements Function<K, V>,
    Serializable {
        final Map<K, V> map;
        private static final long serialVersionUID = 0L;

        FunctionForMapNoDefault(Map<K, V> map) {
            this.map = Preconditions.checkNotNull(map);
        }

        @Override
        public V apply(K k) {
            V v = this.map.get(k);
            Preconditions.checkArgument(v != null || this.map.containsKey(k), "Key '%s' not present in map", k);
            return v;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof FunctionForMapNoDefault) {
                FunctionForMapNoDefault functionForMapNoDefault = (FunctionForMapNoDefault)object;
                return this.map.equals(functionForMapNoDefault.map);
            }
            return false;
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        public String toString() {
            return "forMap(" + this.map + ")";
        }
    }

    private static enum IdentityFunction implements Function<Object, Object>
    {
        INSTANCE;


        @Override
        public Object apply(Object object) {
            return object;
        }

        public String toString() {
            return "identity";
        }
    }

    private static enum ToStringFunction implements Function<Object, String>
    {
        INSTANCE;


        @Override
        public String apply(Object object) {
            Preconditions.checkNotNull(object);
            return object.toString();
        }

        public String toString() {
            return "toString";
        }
    }
}

