/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible
final class Absent
extends Optional<Object> {
    static final Absent INSTANCE = new Absent();
    private static final long serialVersionUID = 0L;

    Absent() {
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public Object get() {
        throw new IllegalStateException("value is absent");
    }

    @Override
    public Object or(Object object) {
        return Preconditions.checkNotNull(object, "use orNull() instead of or(null)");
    }

    @Override
    public Optional<Object> or(Optional<?> optional) {
        return Preconditions.checkNotNull(optional);
    }

    @Override
    public Object or(Supplier<?> supplier) {
        return Preconditions.checkNotNull(supplier.get(), "use orNull() instead of a Supplier that returns null");
    }

    @Override
    @Nullable
    public Object orNull() {
        return null;
    }

    @Override
    public Set<Object> asSet() {
        return Collections.emptySet();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return object == this;
    }

    @Override
    public int hashCode() {
        return 1502476572;
    }

    @Override
    public String toString() {
        return "Optional.absent()";
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

