/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.xml.xpath.functions;

import java.util.List;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;

public class UrlExtractQueryParam
implements XPathFunction {
    public Object evaluate(List args) throws XPathFunctionException {
        if (args == null) {
            throw new XPathFunctionException("Wrong number of arguments to url-query-param(url,paramName)");
        }
        if (args.size() != 2) {
            throw new XPathFunctionException("Wrong number of arguments to url-query-param(url,paramName)");
        }
        String url = (String)args.get(0);
        if (url == null || url.length() == 0) {
            return null;
        }
        String parName = (String)args.get(1);
        if (parName == null || parName.length() == 0) {
            return null;
        }
        String query = this.getQuery(url);
        if (query == null) {
            query = url;
        }
        return this.getParam(query, parName);
    }

    protected String getQuery(String url) {
        int i = url.indexOf("?");
        if (i == -1) {
            return null;
        }
        return url.substring(i + 1);
    }

    protected String getParam(String query, String paramName) {
        String[] arr = query.split("&");
        for (int i = 0; i < arr.length; ++i) {
            String[] val = arr[i].split("=");
            if (!paramName.equals(val[0])) continue;
            if (val.length == 2) {
                return val[1];
            }
            return "";
        }
        return null;
    }
}

