/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.xml.sax;

import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import net.sf.fikin.xml.sax.SAXHandlerAndResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SAXSerializer
extends DefaultHandler
implements SAXHandlerAndResolver {
    static final Log log = LogFactory.getLog((Class)SAXSerializer.class);
    protected BufferedWriter output;
    protected Hashtable namespaces;
    protected Locator locator;
    protected boolean isCanonical = false;
    protected boolean isXML11 = true;
    protected int elementDepth;
    protected boolean inCDATA;
    protected boolean isPreviousStartElement = false;
    protected boolean doIndent = true;
    protected String indent = "   ";

    public SAXSerializer() {
    }

    public SAXSerializer(BufferedWriter out) {
        this.setOutput(out);
    }

    public void setOutput(BufferedWriter out) {
        this.output = out;
    }

    public BufferedWriter getOutput() {
        return this.output;
    }

    protected Hashtable getNamespaces() {
        return this.namespaces;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    public void setIsXMLCanonical(boolean flg) {
        this.isCanonical = flg;
    }

    public boolean getIsXMLCanonical() {
        return this.isCanonical;
    }

    public void setIsXML11(boolean flg) {
        this.isXML11 = flg;
    }

    public boolean getIsXML11() {
        return this.isXML11;
    }

    public void setDoIndent(boolean flg) {
        this.doIndent = flg;
    }

    public boolean getDoIndent() {
        return this.doIndent;
    }

    public void setIndent(String val) {
        this.indent = val;
    }

    public String getIndent() {
        return this.indent;
    }

    public void parse(InputSource input, XMLReader reader) throws SAXException, IOException {
        this.parse(input, reader, null);
    }

    public void parse(String systemId, XMLReader reader) throws SAXException, IOException {
        this.parse(null, reader, systemId);
    }

    protected void parse(InputSource in1, XMLReader reader, String in2) throws SAXException, IOException {
        reader.setContentHandler(this);
        reader.setDTDHandler(this);
        reader.setEntityResolver(this);
        try {
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (SAXException e) {
            // empty catch block
        }
        if (in1 == null) {
            reader.parse(in2);
        } else {
            reader.parse(in1);
        }
    }

    protected SAXException newLocationException(String msg) {
        return new SAXException(msg);
    }

    protected SAXException newLocationException(Exception e) {
        return new SAXException(e);
    }

    protected SAXException newLocationException(String msg, Exception e) {
        return new SAXException(msg, e);
    }

    protected SAXException newLocationException(String method, int cnt, String msg) {
        return this.newLocationException("exception while executing method " + method + " with number of arguments " + cnt + " " + msg);
    }

    protected SAXException newLocationException(String method, int cnt, Exception e) {
        return this.newLocationException("exception while executing method " + method + " with number of arguments " + cnt, e);
    }

    protected SAXException newLocationException(Method method, Attributes attributes, String msg) {
        return this.newLocationException(method.getName(), attributes.getLength(), msg);
    }

    protected SAXException newLocationException(String method, Attributes attributes, String msg) {
        return this.newLocationException(method, attributes.getLength(), msg);
    }

    protected SAXException newLocationException(String method, Attributes attributes, Exception e) {
        return this.newLocationException(method, attributes.getLength(), e);
    }

    public void startDocument() throws SAXException {
        this.namespaces = new Hashtable();
        this.isXML11 = false;
        this.elementDepth = 0;
        this.inCDATA = false;
        if (this.getDocumentLocator() != null) {
            this.setIsXML11("1.1".equals(this.getXMLVersion()));
        }
        try {
            if (!this.getIsXMLCanonical()) {
                if (this.getIsXML11()) {
                    this.getOutput().write("<?xml version=\"1.1\" encoding=\"UTF-8\"?>");
                } else {
                    this.getOutput().write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                }
                this.getOutput().newLine();
            }
        }
        catch (IOException e) {
            throw this.newLocationException(e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.getOutput().flush();
        }
        catch (IOException e) {
            throw new SAXException("exception while flushing", e);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.getNamespaces().put(uri, prefix);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            this.writeClosingTag(false);
            ++this.elementDepth;
            if (this.getDoIndent() && this.elementDepth > 1) {
                this.getOutput().newLine();
                this.printIndent(this.elementDepth);
            }
            this.getOutput().write(60);
            this.getOutput().write(qName);
            Enumeration e = this.getNamespaces().keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.getOutput().write(" xmlns:");
                this.getOutput().write((String)this.getNamespaces().get(key));
                this.getOutput().write("=\"");
                this.getOutput().write(key);
                this.getOutput().write(34);
            }
            this.getNamespaces().clear();
            Iterator i = this.sortAttributes(attributes);
            while (i.hasNext()) {
                String qname = (String)i.next();
                this.getOutput().write(32);
                this.getOutput().write(qname);
                this.getOutput().write("=\"");
                this.getOutput().write(this.normalize(attributes.getValue(qname), true));
                this.getOutput().write(34);
            }
            this.isPreviousStartElement = true;
        }
        catch (IOException e) {
            throw this.newLocationException(e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.elementDepth;
        try {
            if (this.isPreviousStartElement) {
                this.writeClosingTag(true);
            } else {
                if (this.getDoIndent()) {
                    this.getOutput().newLine();
                    if (this.elementDepth > 0) {
                        this.printIndent(this.elementDepth + 1);
                    }
                }
                this.getOutput().write("</");
                this.getOutput().write(qName);
                this.getOutput().write(62);
            }
        }
        catch (IOException e) {
            throw this.newLocationException(e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.writeClosingTag(false);
            if (this.inCDATA) {
                this.getOutput().write(ch, start, length);
            } else {
                this.getOutput().write(this.normalize(ch, start, length, false));
            }
        }
        catch (IOException e) {
            throw this.newLocationException(e);
        }
    }

    public void characters(String str) throws SAXException {
        char[] ch = str.toCharArray();
        this.characters(ch, 0, ch.length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.writeClosingTag(false);
            this.getOutput().write(ch, start, length);
        }
        catch (IOException e) {
            throw this.newLocationException(e);
        }
    }

    public void ignorableWhitespace(String str) throws SAXException {
        char[] ch = str.toCharArray();
        this.ignorableWhitespace(ch, 0, ch.length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.writeClosingTag(false);
            this.getOutput().write("<?");
            this.getOutput().write(target);
            if (data != null && data.length() > 0) {
                this.getOutput().write(32);
                this.getOutput().write(data);
            }
            this.getOutput().write("?>");
            this.getOutput().newLine();
        }
        catch (IOException e) {
            throw this.newLocationException(e);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        try {
            this.writeClosingTag(false);
            if (!this.getIsXMLCanonical()) {
                this.getOutput().write("<![CDATA[");
                this.inCDATA = true;
            }
        }
        catch (IOException e) {
            throw this.newLocationException(e);
        }
    }

    public void endCDATA() throws SAXException {
        try {
            this.writeClosingTag(false);
            if (!this.getIsXMLCanonical()) {
                this.getOutput().write("]]>");
                this.inCDATA = false;
            }
        }
        catch (IOException e) {
            throw this.newLocationException(e);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        try {
            this.writeClosingTag(false);
            if (this.getDoIndent()) {
                this.getOutput().newLine();
                this.printIndent(this.elementDepth);
            }
            if (!this.getIsXMLCanonical() && this.elementDepth > 0) {
                this.getOutput().write("<!--");
                this.getOutput().write(ch, start, length);
                this.getOutput().write("-->");
            }
        }
        catch (IOException e) {
            throw this.newLocationException(e);
        }
    }

    public void comment(String str) throws SAXException {
        char[] ch = str.toCharArray();
        this.comment(ch, 0, ch.length);
    }

    protected void writeClosingTag(boolean isEndElementEvent) throws IOException {
        if (this.isPreviousStartElement) {
            if (isEndElementEvent) {
                this.getOutput().write("/>");
            } else {
                this.getOutput().write(">");
            }
            this.isPreviousStartElement = false;
        }
    }

    protected Iterator sortAttributes(Attributes attrs) {
        if (attrs == null) {
            attrs = new AttributesImpl();
        }
        Object[] qnames = new String[attrs.getLength()];
        for (int i = 0; i < attrs.getLength(); ++i) {
            qnames[i] = attrs.getQName(i);
        }
        Arrays.sort(qnames);
        return Arrays.asList(qnames).iterator();
    }

    protected String normalize(String s, boolean isAttValue) {
        StringBuffer buf = new StringBuffer();
        if (s == null || s.length() == 0) {
            return "";
        }
        for (int i = 0; i < s.length(); ++i) {
            buf.append(this.normalize(s.charAt(i), isAttValue));
        }
        return buf.toString();
    }

    protected String normalize(char[] ch, int offset, int length, boolean isAttValue) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            buf.append(this.normalize(ch[offset + i], isAttValue));
        }
        return buf.toString();
    }

    protected String normalize(char c, boolean isAttValue) {
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '&': {
                return "&amp;";
            }
            case '\"': {
                if (isAttValue) {
                    return "&quot;";
                }
                return "\"";
            }
            case '\r': {
                return "&#xD;";
            }
            case '\n': {
                if (!this.getIsXMLCanonical()) break;
                return "&#xA;";
            }
        }
        if (this.getIsXML11() && (c >= '\u0001' && c <= '\u001f' && c != '\t' && c != '\n' || c >= '\u007f' && c <= '\u009f' || c == '\u2028') || isAttValue && (c == '\t' || c == '\n')) {
            return "&#x" + Integer.toHexString(c).toUpperCase() + ";";
        }
        return Character.toString(c);
    }

    protected String getXMLVersion() {
        if (this.getDocumentLocator() == null) {
            return null;
        }
        String version = null;
        Method getXMLVersion = null;
        try {
            getXMLVersion = this.getDocumentLocator().getClass().getMethod("getXMLVersion", new Class[0]);
            if (getXMLVersion != null) {
                version = (String)getXMLVersion.invoke((Object)this.getDocumentLocator(), (Object[])null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    public void warning(SAXParseException ex) throws SAXException {
        this.printError("Warning", ex);
    }

    public void error(SAXParseException ex) throws SAXException {
        this.printError("Error", ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.printError("Fatal Error", ex);
        throw ex;
    }

    protected void printError(String type, SAXParseException ex) {
        System.err.print("[");
        System.err.print(type);
        System.err.print("] ");
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            System.err.print(systemId);
        }
        System.err.print(':');
        System.err.print(ex.getLineNumber());
        System.err.print(':');
        System.err.print(ex.getColumnNumber());
        System.err.print(": ");
        System.err.print(ex.getMessage());
        System.err.println();
        System.err.flush();
    }

    protected void printIndent(int howmany) throws IOException {
        for (int i = 1; i < howmany; ++i) {
            this.getOutput().write(this.getIndent());
        }
    }
}

