/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.xml.sax;

import net.sf.fikin.xml.sax.SAXHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class PipeHandler
implements SAXHandler {
    DTDHandler dtdHandler = null;
    LexicalHandler lexicalHandler = null;
    ErrorHandler errorHandler = null;
    ContentHandler contentHandler = null;
    Locator locator = null;

    public PipeHandler() {
    }

    public PipeHandler(Object handler) {
        this.setHandler(handler);
    }

    public void setHandler(Object handler) {
        if (handler instanceof DTDHandler) {
            this.setDTDHandler((DTDHandler)handler);
        }
        if (handler instanceof LexicalHandler) {
            this.setLexicalHandler((LexicalHandler)handler);
        }
        if (handler instanceof ErrorHandler) {
            this.setErrorHandler((ErrorHandler)handler);
        }
        if (handler instanceof ContentHandler) {
            this.setContentHandler((ContentHandler)handler);
        }
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        this.dtdHandler = dtdHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.dtdHandler != null) {
            this.dtdHandler.notationDecl(name, publicId, systemId);
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (this.dtdHandler != null) {
            this.dtdHandler.unparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }

    public void setDocumentLocator(Locator locator) {
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(locator);
        }
    }

    public void startDocument() throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.startDocument();
        }
    }

    public void endDocument() throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.endDocument();
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.endPrefixMapping(prefix);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.startElement(uri, localName, qName, atts);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.endElement(uri, localName, qName);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.characters(ch, start, length);
        }
    }

    public void characters(String text) throws SAXException {
        if (this.contentHandler != null) {
            char[] ch = text.toCharArray();
            this.contentHandler.characters(ch, 0, ch.length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.ignorableWhitespace(ch, start, length);
        }
    }

    public void ignorableWhitespace(String text) throws SAXException {
        if (this.contentHandler != null) {
            char[] ch = text.toCharArray();
            this.contentHandler.ignorableWhitespace(ch, 0, ch.length);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.skippedEntity(name);
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.warning(exception);
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.error(exception);
        }
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(exception);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    public void endDTD() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    public void startEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, length);
        }
    }

    public void comment(String text) throws SAXException {
        if (this.lexicalHandler != null) {
            char[] ch = text.toCharArray();
            this.lexicalHandler.comment(ch, 0, ch.length);
        }
    }
}

