/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.xml.sax;

import net.sf.fikin.xml.sax.BufferHandler;
import net.sf.fikin.xml.sax.PipeHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class BufferingPipe
extends PipeHandler {
    protected boolean inBufferMode = false;
    protected int markedDepth = 0;
    protected int elementDepth = 0;
    protected BufferHandler buffer;
    DTDHandler origDtdHandler = null;
    LexicalHandler origLexicalHandler = null;
    ErrorHandler origErrorHandler = null;
    ContentHandler origContentHandler = null;

    public BufferingPipe() {
    }

    public BufferingPipe(Object handler) {
        super(handler);
    }

    public void bufferInto(BufferHandler buffer) {
        this.inBufferMode = true;
        this.markedDepth = this.elementDepth;
        this.buffer = buffer;
        this.origDtdHandler = this.getDTDHandler();
        this.origLexicalHandler = this.getLexicalHandler();
        this.origErrorHandler = this.getErrorHandler();
        this.origContentHandler = this.getContentHandler();
        this.setHandler(buffer);
    }

    protected void exitBufferingMode() {
        this.inBufferMode = false;
        this.setDTDHandler(this.origDtdHandler);
        this.setLexicalHandler(this.origLexicalHandler);
        this.setErrorHandler(this.origErrorHandler);
        this.setContentHandler(this.origContentHandler);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        ++this.elementDepth;
        super.startElement(uri, localName, qName, atts);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.elementDepth;
        if (this.elementDepth == this.markedDepth && this.inBufferMode) {
            this.exitBufferingMode();
        }
        super.endElement(uri, localName, qName);
    }
}

