/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.xml.sax;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import net.sf.fikin.xml.sax.SAXHandlerAndResolver;
import net.sf.fikin.xml.sax.events.AbstractEvent;
import net.sf.fikin.xml.sax.events.CharactersEvent;
import net.sf.fikin.xml.sax.events.CommentEvent;
import net.sf.fikin.xml.sax.events.ContentHandlerEvent;
import net.sf.fikin.xml.sax.events.DTDHandlerEvent;
import net.sf.fikin.xml.sax.events.DocumentLocatorEvent;
import net.sf.fikin.xml.sax.events.EndCDataEvent;
import net.sf.fikin.xml.sax.events.EndDTDEvent;
import net.sf.fikin.xml.sax.events.EndDocumentEvent;
import net.sf.fikin.xml.sax.events.EndElementEvent;
import net.sf.fikin.xml.sax.events.EndEntityEvent;
import net.sf.fikin.xml.sax.events.EndPrefixMappingEvent;
import net.sf.fikin.xml.sax.events.ErrorEvent;
import net.sf.fikin.xml.sax.events.ErrorHandlerEvent;
import net.sf.fikin.xml.sax.events.FatalErrorEvent;
import net.sf.fikin.xml.sax.events.IgnorableWhitespaceEvent;
import net.sf.fikin.xml.sax.events.LexicalHandlerEvent;
import net.sf.fikin.xml.sax.events.NotationDeclEvent;
import net.sf.fikin.xml.sax.events.ProcessingInstructionEvent;
import net.sf.fikin.xml.sax.events.SkippedEntityEvent;
import net.sf.fikin.xml.sax.events.StartCDataEvent;
import net.sf.fikin.xml.sax.events.StartDTDEvent;
import net.sf.fikin.xml.sax.events.StartDocumentEvent;
import net.sf.fikin.xml.sax.events.StartElementEvent;
import net.sf.fikin.xml.sax.events.StartEntityEvent;
import net.sf.fikin.xml.sax.events.StartPrefixMappingEvent;
import net.sf.fikin.xml.sax.events.UnparsedEntityDeclEvent;
import net.sf.fikin.xml.sax.events.WarningEvent;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class BufferHandler
implements SAXHandlerAndResolver {
    Vector values;

    public BufferHandler() {
        this.values = new Vector();
    }

    public BufferHandler(int initialSize) {
        this.values = new Vector(initialSize);
    }

    protected Vector getBuffer() {
        return this.values;
    }

    public void clear() {
        this.values.clear();
    }

    public void emmit(ContentHandler handler) throws SAXException, IOException {
        DTDHandler dtdHandler = null;
        if (handler instanceof DTDHandler) {
            dtdHandler = (DTDHandler)((Object)handler);
        }
        LexicalHandler lexicalHandler = null;
        if (handler instanceof LexicalHandler) {
            lexicalHandler = (LexicalHandler)((Object)handler);
        }
        ErrorHandler errorHandler = null;
        if (handler instanceof ErrorHandler) {
            errorHandler = (ErrorHandler)((Object)handler);
        }
        ContentHandler contentHandler = null;
        if (handler instanceof ContentHandler) {
            contentHandler = handler;
        }
        Iterator i = this.values.iterator();
        while (i.hasNext()) {
            AbstractEvent event = (AbstractEvent)i.next();
            if (event instanceof DTDHandlerEvent && dtdHandler != null) {
                ((DTDHandlerEvent)event).emmit(dtdHandler);
                continue;
            }
            if (event instanceof LexicalHandlerEvent && lexicalHandler != null) {
                ((LexicalHandlerEvent)event).emmit(lexicalHandler);
                continue;
            }
            if (event instanceof ErrorHandlerEvent && errorHandler != null) {
                ((ErrorHandlerEvent)event).emmit(errorHandler);
                continue;
            }
            if (event instanceof ContentHandlerEvent && contentHandler != null) {
                ((ContentHandlerEvent)event).emmit(contentHandler);
                continue;
            }
            throw new SAXException("Unsupported SAX Event: " + event.toString());
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        this.values.add(new NotationDeclEvent(name, publicId, systemId));
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        this.values.add(new UnparsedEntityDeclEvent(name, publicId, systemId, notationName));
    }

    public void setDocumentLocator(Locator locator) {
        this.values.add(new DocumentLocatorEvent(locator));
    }

    public void startDocument() throws SAXException {
        this.values.add(new StartDocumentEvent());
    }

    public void endDocument() throws SAXException {
        this.values.add(new EndDocumentEvent());
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.values.add(new StartPrefixMappingEvent(prefix, uri));
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.values.add(new EndPrefixMappingEvent(prefix));
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.values.add(new StartElementEvent(uri, localName, qName, atts));
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.values.add(new EndElementEvent(uri, localName, qName));
    }

    public void characters(String str) throws SAXException {
        char[] ch = str.toCharArray();
        this.characters(ch, 0, ch.length);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.values.add(new CharactersEvent(ch, start, length));
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.values.add(new IgnorableWhitespaceEvent(ch, start, length));
    }

    public void ignorableWhitespace(String str) throws SAXException {
        char[] ch = str.toCharArray();
        this.ignorableWhitespace(ch, 0, ch.length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.values.add(new ProcessingInstructionEvent(target, data));
    }

    public void skippedEntity(String name) throws SAXException {
        this.values.add(new SkippedEntityEvent(name));
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.values.add(new WarningEvent(exception));
    }

    public void error(SAXParseException exception) throws SAXException {
        this.values.add(new ErrorEvent(exception));
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.values.add(new FatalErrorEvent(exception));
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.values.add(new StartDTDEvent(name, publicId, systemId));
    }

    public void endDTD() throws SAXException {
        this.values.add(new EndDTDEvent());
    }

    public void startEntity(String name) throws SAXException {
        this.values.add(new StartEntityEvent(name));
    }

    public void endEntity(String name) throws SAXException {
        this.values.add(new EndEntityEvent(name));
    }

    public void startCDATA() throws SAXException {
        this.values.add(new StartCDataEvent());
    }

    public void endCDATA() throws SAXException {
        this.values.add(new EndCDataEvent());
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.values.add(new CommentEvent(ch, start, length));
    }

    public void comment(String str) throws SAXException {
        char[] ch = str.toCharArray();
        this.comment(ch, 0, ch.length);
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return null;
    }
}

