/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.WeakHashMap;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.fikin.xml.StderrErrorListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Xslt {
    static final Log log = LogFactory.getLog((Class)Xslt.class);
    static TransformerFactory defaultFact = TransformerFactory.newInstance();
    static WeakHashMap javaObjExports = new WeakHashMap();
    Templates tmpl;
    ErrorListener errorListener;

    public Xslt(TransformerFactory fact, Source xsl) throws TransformerConfigurationException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("fact=" + fact + ",xsl=" + xsl));
        }
        this.tmpl = fact.newTemplates(xsl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("tmpl=" + this.tmpl.toString()));
        }
        this.errorListener = new StderrErrorListener();
    }

    public Xslt(Source xsl) throws TransformerConfigurationException {
        this(defaultFact, xsl);
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public void transform(Source in, Result out, Hashtable params) throws TransformerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("in=" + in.toString() + "out=" + out.toString() + ", params=" + params.toString()));
        }
        Transformer tr = this.tmpl.newTransformer();
        if (log.isDebugEnabled()) {
            log.debug((Object)("tr=" + tr.toString()));
        }
        tr.setErrorListener(this.errorListener);
        Enumeration e = params.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            tr.setParameter(key, params.get(key));
        }
        tr.transform(in, out);
    }

    public void transform(Source in, Result out) throws TransformerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("in=" + in.toString() + ", out=" + out.toString()));
        }
        this.transform(in, out, new Hashtable());
    }

    public void transform(Source in, Hashtable params) throws TransformerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("in=" + in.toString() + ", params=" + params.toString()));
        }
        this.transform(in, new StreamResult(new StringWriter(100)), params);
    }

    public void transform(Source in) throws TransformerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("in=" + in.toString()));
        }
        this.transform(in, new Hashtable(0));
    }

    public String exportJavaObject(Object obj) {
        if (obj == null) {
            throw new NullPointerException("exportJavaObject(Object): Object must not be null!");
        }
        String key = this.toString() + obj.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("key=" + key + ", obj=" + obj + ", javaObjExports=" + javaObjExports));
        }
        javaObjExports.put(key, obj);
        return key;
    }

    public static Object lookupObject(String key) {
        Object ret = javaObjExports.remove(key);
        if (log.isDebugEnabled()) {
            log.debug((Object)("key=" + key + ", value=" + ret));
        }
        return ret;
    }

    public static StreamSource newStreamSource(Reader in) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reader=" + in.toString()));
        }
        return new StreamSource(in);
    }

    public static StreamSource newStreamSource(InputStream in) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("InputStream=" + in.toString()));
        }
        return new StreamSource(in);
    }

    public static StreamSource newStreamSource(File in) throws FileNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("File=" + in.toString()));
        }
        return Xslt.newStreamSource(new BufferedInputStream(new FileInputStream(in)));
    }

    public static StreamSource newStreamSource(URL in) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("url=" + in));
        }
        return Xslt.newStreamSource(new BufferedInputStream(in.openStream()));
    }

    public static StreamSource newStreamSource(String file) throws FileNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("file=" + file));
        }
        return Xslt.newStreamSource(new File(file));
    }

    public static StreamSource newStreamSource(String fqnFile, ClassLoader cl) throws NullPointerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("fqnFile=" + fqnFile + ", cl=" + cl));
        }
        InputStream in = null;
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying " + fqnFile + " with System ClassLoader " + cl));
            }
            if ((in = ClassLoader.getSystemResourceAsStream(fqnFile)) == null) {
                cl = Xslt.class.getClassLoader();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Trying " + fqnFile + " with Xslt.class ClassLoader " + cl));
                }
                in = cl.getResourceAsStream(fqnFile);
            }
            if (in == null) {
                cl = Thread.currentThread().getContextClassLoader();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Trying " + fqnFile + " with Thread.currentThread() ClassLoader " + cl));
                }
                in = cl.getResourceAsStream(fqnFile);
            }
        } else {
            in = cl.getResourceAsStream(fqnFile);
        }
        if (in == null) {
            throw new NullPointerException("Resource " + fqnFile + " not found!");
        }
        return Xslt.newStreamSource(in);
    }

    public static StreamSource newStreamSource(String file, Package pkg) {
        String str = pkg.getName().replaceAll("\\.", "/") + "/" + file;
        if (log.isDebugEnabled()) {
            log.debug((Object)("file=" + str + ", pkg=" + pkg.toString()));
        }
        return Xslt.newStreamSource(str, pkg.getClass().getClassLoader());
    }

    public static StreamSource newStreamSource(String file, Class callingCls) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("file=" + file + ", cls=" + callingCls.toString()));
        }
        return Xslt.newStreamSource(file, callingCls.getPackage());
    }
}

