/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import net.sf.fikin.xml.sax.SAXSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TemplateEngine
extends SAXSerializer {
    static final Log log = LogFactory.getLog((Class)TemplateEngine.class);
    public static final String NAMESPACE = "http://sf.net/fikin-ant-tasks/xml/sax-template-engine";
    XMLReader reader;
    Object lookupObject;
    Hashtable methods;

    public TemplateEngine() throws SAXException {
        this.setXMLReader(TemplateEngine.newXMLReader());
    }

    public TemplateEngine(XMLReader reader) throws SAXException {
        this.setXMLReader(reader);
    }

    protected void setXMLReader(XMLReader r) {
        if (log.isDebugEnabled()) {
            log.debug((Object)r);
        }
        if (r == null) {
            throw new NullPointerException("XMLReader is null");
        }
        this.reader = r;
        this.reader.setContentHandler(this);
        this.reader.setDTDHandler(this);
        this.reader.setEntityResolver(this);
    }

    public XMLReader getReader() {
        return this.reader;
    }

    public Hashtable getMethods() {
        return this.methods;
    }

    protected void setLookupObject(Object lookupObject) {
        if (log.isDebugEnabled()) {
            log.debug(lookupObject);
        }
        if (lookupObject == null) {
            throw new NullPointerException("Lookup object is null");
        }
        this.lookupObject = lookupObject;
        this.indexMethods(lookupObject);
    }

    public Object getLookupObject() {
        return this.lookupObject;
    }

    public void transform(InputSource input, Object lookupObject, BufferedWriter output) throws SAXException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("input=" + input + ", lookupObject=" + lookupObject + ", output=" + output));
        }
        if (input == null) {
            throw new NullPointerException("Input is null");
        }
        if (lookupObject == null) {
            throw new NullPointerException("Lookup Object is null");
        }
        if (output == null) {
            throw new NullPointerException("output is null");
        }
        this.setOutput(output);
        this.setLookupObject(lookupObject);
        this.getReader().parse(input);
    }

    public void transform(InputSource input, BufferedWriter output) throws SAXException, IOException {
        this.transform(input, this, output);
    }

    public void transform(InputSource input) throws SAXException, IOException {
        this.transform(input, new BufferedWriter(TemplateEngine.newOutput()));
    }

    public void transform(InputSource input, Object lookupObject) throws SAXException, IOException {
        this.transform(input, lookupObject, new BufferedWriter(TemplateEngine.newOutput()));
    }

    protected void indexMethods(Object lookupObject) {
        HashSet<String> ignored = new HashSet<String>();
        this.methods = new Hashtable();
        Iterator<Method> i = Arrays.asList(lookupObject.getClass().getMethods()).iterator();
        while (i.hasNext()) {
            String key;
            Method m = i.next();
            if ("void".equals(m.getReturnType().toString()) || !Modifier.isPublic(m.getModifiers()) || ignored.contains(key = m.getName() + "-" + m.getParameterTypes().length)) continue;
            if (this.methods.get(key) == null) {
                this.methods.put(key, m);
                continue;
            }
            this.methods.remove(key);
            ignored.add(key);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Method " + m.getName() + " with number of aguments " + m.getParameterTypes().length + " exists more than once in class " + lookupObject.getClass().getName() + "\nIgnoring it!"));
        }
    }

    protected String invokeMethod(String methodName, Attributes attributes) throws SAXException {
        Method m;
        if (log.isDebugEnabled()) {
            log.debug((Object)("methodName=" + methodName));
        }
        if ((m = (Method)this.getMethods().get(methodName + "-" + attributes.getLength())) == null) {
            throw this.newLocationException(methodName, attributes, " does not exists in class " + this.lookupObject.getClass().getName());
        }
        try {
            Object ret = m.invoke(this.getLookupObject(), this.convertAtttibutes(m, attributes));
            if (ret == null) {
                return "";
            }
            return ret.toString();
        }
        catch (IllegalAccessException e) {
            throw this.newLocationException(methodName, attributes, (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw this.newLocationException(methodName, attributes, (Exception)e);
        }
    }

    protected Object[] convertAtttibutes(Method method, Attributes attributes) {
        Object[] val = new Object[attributes.getLength()];
        Iterator qnames = this.sortAttributes(attributes);
        int i = 0;
        while (qnames.hasNext()) {
            val[i++] = attributes.getValue((String)qnames.next());
        }
        return val;
    }

    protected void reset() {
        this.output = null;
        this.lookupObject = null;
        this.methods = null;
    }

    public String empty() {
        return "";
    }

    public String forAll(Iterator iterator) {
        while (iterator.hasNext()) {
        }
        return null;
    }

    public static XMLReader newXMLReader() throws SAXException {
        return XMLReaderFactory.createXMLReader();
    }

    public static XMLReader newXMLReader(String readerClassName) throws SAXException {
        if (readerClassName == null || readerClassName.length() == 0) {
            throw new NullPointerException("Reader class name is null");
        }
        return XMLReaderFactory.createXMLReader(readerClassName);
    }

    public static InputSource newInputSource(InputStream in) {
        if (in == null) {
            throw new NullPointerException("Input stream is null");
        }
        return new InputSource(in);
    }

    public static InputSource newInputSource(Reader in) {
        if (in == null) {
            throw new NullPointerException("Input reader is null");
        }
        return new InputSource(in);
    }

    public static InputSource newInputSourceFromSystemId(String systemId) {
        if (systemId == null || systemId.length() == 0) {
            throw new NullPointerException("SystemId is null");
        }
        return new InputSource(systemId);
    }

    public static InputSource newInputSource(File in) throws FileNotFoundException {
        if (in == null) {
            throw new NullPointerException("Input file is null");
        }
        return TemplateEngine.newInputSource(new BufferedReader(new FileReader(in)));
    }

    public static InputSource newInputSourceFromFile(String file) throws FileNotFoundException {
        if (file == null || file.length() == 0) {
            throw new NullPointerException("File name is null");
        }
        return TemplateEngine.newInputSource(new File(file));
    }

    public static InputSource newInputSource(URL in) throws IOException {
        if (in == null) {
            throw new NullPointerException("Input URL is null");
        }
        return new InputSource(in.openStream());
    }

    public static InputSource newInputSource(String fqnFile, ClassLoader cl) {
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if (fqnFile == null) {
            throw new NullPointerException("Fully qualified file name is null");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("fqnFile=" + fqnFile + ", cl=" + cl.toString()));
        }
        InputStream in = cl.getResourceAsStream(fqnFile);
        return TemplateEngine.newInputSource(in);
    }

    public static InputSource newInputSource(String file, Package pkg) {
        if (file == null || file.length() == 0) {
            throw new NullPointerException("File name is null");
        }
        if (pkg == null) {
            throw new NullPointerException("Package is null");
        }
        String str = pkg.getName().replaceAll("\\.", "/") + "/" + file;
        if (log.isDebugEnabled()) {
            log.debug((Object)("file=" + str + ", pkg=" + pkg.toString()));
        }
        return TemplateEngine.newInputSource(str, pkg.getClass().getClassLoader());
    }

    public static InputSource newInputSource(String file, Class callingCls) {
        if (file == null || file.length() == 0) {
            throw new NullPointerException("File name is null");
        }
        if (callingCls == null) {
            throw new NullPointerException("Calling class is null");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("file=" + file + ", cls=" + callingCls.toString()));
        }
        return TemplateEngine.newInputSource(file, callingCls.getPackage());
    }

    public static InputSource newInputSourceFromCode(String code) {
        if (code == null) {
            throw new NullPointerException("Code is null");
        }
        return TemplateEngine.newInputSource(new StringReader(code));
    }

    public static CharArrayWriter newOutput() {
        return new CharArrayWriter(8096);
    }

    public static CharArrayWriter newOutput(int initialSize) {
        return new CharArrayWriter(initialSize);
    }

    public static BufferedWriter newOutput(File out) throws IOException {
        return new BufferedWriter(new FileWriter(out));
    }

    public static BufferedWriter newOutputFromFile(String file) throws IOException {
        return TemplateEngine.newOutput(new File(file));
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.reset();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (uri.equals(NAMESPACE)) {
                this.writeClosingTag(false);
                this.getOutput().write(this.invokeMethod(localName, attributes));
            } else {
                super.startElement(uri, localName, qName, attributes);
            }
        }
        catch (IOException e) {
            throw this.newLocationException(e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!uri.equals(NAMESPACE)) {
            super.endElement(uri, localName, qName);
        }
    }
}

