/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.WeakHashMap;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import net.sf.fikin.xml.StderrErrorListener;
import net.sf.joost.trax.TransformerFactoryImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class Stx {
    static final Log log = LogFactory.getLog((Class)Stx.class);
    static SAXTransformerFactory saxtf;
    static WeakHashMap javaObjExports;
    TransformerHandler tmpl;
    ErrorListener errorListener;

    public Stx(SAXSource stx) throws TransformerConfigurationException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("fact=" + saxtf));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("javax.xml.transform.TransformerFactory=" + System.getProperty("javax.xml.transform.TransformerFactory")));
        }
        if (saxtf == null) {
            try {
                saxtf = new TransformerFactoryImpl();
            }
            catch (IOException e) {
                throw new TransformerConfigurationException(e);
            }
        }
        this.tmpl = saxtf.newTransformerHandler(stx);
        this.errorListener = new StderrErrorListener();
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void transform(SAXSource in, Result out, Hashtable params) throws TransformerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("in=" + in.toString() + "out=" + out.toString() + ", params=" + params.toString()));
        }
        Transformer tr = this.tmpl.getTransformer();
        if (log.isDebugEnabled()) {
            log.debug((Object)("tr=" + tr.toString()));
        }
        tr.setErrorListener(this.errorListener);
        Enumeration e = params.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            tr.setParameter(key, params.get(key));
        }
        tr.transform(in, out);
    }

    public void transform(SAXSource in, Result out) throws TransformerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("in=" + in.toString() + ", out=" + out.toString()));
        }
        this.transform(in, out, new Hashtable());
    }

    public void transform(SAXSource in, Hashtable params) throws TransformerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("in=" + in.toString() + ", params=" + params.toString()));
        }
        this.transform(in, new SAXResult(new DefaultHandler()), params);
    }

    public void transform(SAXSource in) throws TransformerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("in=" + in.toString()));
        }
        this.transform(in, new Hashtable(0));
    }

    public String exportJavaObject(Object obj) {
        if (obj == null) {
            throw new NullPointerException("exportJavaObject(Object): Object must not be null!");
        }
        String key = this.toString() + obj.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("key=" + key + ", obj=" + obj + ", javaObjExports=" + javaObjExports));
        }
        javaObjExports.put(key, obj);
        return key;
    }

    public static Object lookupObject(String key) {
        Object ret = javaObjExports.remove(key);
        if (log.isDebugEnabled()) {
            log.debug((Object)("key=" + key + ", value=" + ret + ", javaObjExports=" + javaObjExports));
        }
        return ret;
    }

    public static SAXSource newSAXSource(Reader in) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reader=" + in.toString()));
        }
        return new SAXSource(new InputSource(in));
    }

    public static SAXSource newSAXSource(InputStream in) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("InputStream=" + in.toString()));
        }
        return new SAXSource(new InputSource(in));
    }

    public static SAXSource newSAXSource(File in) throws FileNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("File=" + in.toString()));
        }
        return Stx.newSAXSource(new BufferedInputStream(new FileInputStream(in)));
    }

    public static SAXSource newSAXSource(URL in) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("url=" + in));
        }
        return Stx.newSAXSource(new BufferedInputStream(in.openStream()));
    }

    public static SAXSource newSAXSource(String file) throws FileNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("file=" + file));
        }
        return Stx.newSAXSource(new File(file));
    }

    public static SAXSource newSAXSource(String fqnFile, ClassLoader cl) throws NullPointerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("fqnFile=" + fqnFile + ", cl=" + cl));
        }
        InputStream in = null;
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying " + fqnFile + " with System ClassLoader " + cl));
            }
            if ((in = ClassLoader.getSystemResourceAsStream(fqnFile)) == null) {
                cl = Stx.class.getClassLoader();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Trying " + fqnFile + " with Stx.class ClassLoader " + cl));
                }
                in = cl.getResourceAsStream(fqnFile);
            }
            if (in == null) {
                cl = Thread.currentThread().getContextClassLoader();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Trying " + fqnFile + " with Thread.currentThread() ClassLoader " + cl));
                }
                in = cl.getResourceAsStream(fqnFile);
            }
        } else {
            in = cl.getResourceAsStream(fqnFile);
        }
        if (in == null) {
            throw new NullPointerException("Resource " + fqnFile + " not found!");
        }
        return Stx.newSAXSource(in);
    }

    public static SAXSource newSAXSource(String file, Package pkg) {
        String str = pkg.getName().replaceAll("\\.", "/") + "/" + file;
        if (log.isDebugEnabled()) {
            log.debug((Object)("file=" + str + ", pkg=" + pkg.toString()));
        }
        return Stx.newSAXSource(str, pkg.getClass().getClassLoader());
    }

    public static SAXSource newSAXSource(String file, Class callingCls) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("file=" + file + ", cls=" + callingCls.toString()));
        }
        return Stx.newSAXSource(file, callingCls.getPackage());
    }

    static {
        javaObjExports = new WeakHashMap();
    }
}

