/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.sql.oracle;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import net.sf.fikin.sql.SQLPipeElement;
import net.sf.fikin.sql.core.JdbcConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SetServerOut
extends SQLPipeElement {
    static final Log log = LogFactory.getLog((Class)SetServerOut.class);
    boolean outOn = true;
    int size = 900000;
    boolean lastTimeoutOn = false;

    public SetServerOut() {
    }

    public SetServerOut(boolean echoOn) {
        this.setServerOutOn(echoOn);
    }

    public boolean getServerOutOn() {
        return this.outOn;
    }

    public void setServerOutOn(boolean outOn) {
        this.outOn = outOn;
    }

    public void execute(String cmd) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("serverOutOn=" + this.getServerOutOn() + ",cmd=" + cmd));
        }
        if (this.lastTimeoutOn && !this.getServerOutOn()) {
            this.switchItOff();
        }
        if (!this.lastTimeoutOn && this.getServerOutOn()) {
            this.switchItOn();
        }
        this.getNext().execute(cmd);
    }

    protected void switchItOn() throws SQLException {
        CallableStatement cal = this.createStmt("{call DBMS_OUTPUT.ENABLE(?)}");
        cal.setInt(1, this.size);
        cal.execute();
    }

    protected void switchItOff() throws SQLException {
        CallableStatement cal = this.createStmt("{call DBMS_OUTPUT.DISABLE}");
        cal.execute();
    }

    protected CallableStatement createStmt(String sql) throws SQLException {
        JdbcConnection jdbcCon = (JdbcConnection)this.getPipe().get(JdbcConnection.class);
        Connection con = jdbcCon.getConnection();
        return con.prepareCall(sql);
    }
}

