/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.sql.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import net.sf.fikin.sql.SQLExceptionDecorator;
import net.sf.fikin.sql.SQLPipeElement;
import net.sf.fikin.sql.core.AbstractOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SimpleXmlFile
extends SQLPipeElement {
    static final Log log = LogFactory.getLog((Class)SimpleXmlFile.class);
    public static final String DEFAULT_URI = "http://fikin-ant-tasks.sf.net/sql/simple-input.xsd";
    public static final String DEFAULT_TAG = "stmt";
    SimpleSAXParser parser;
    XMLReader reader;
    InputSource input;
    String fileName;
    String uri = "http://fikin-ant-tasks.sf.net/sql/simple-input.xsd";
    String tag = "stmt";

    public SimpleXmlFile() throws SAXException {
        this.setSAXParser(this.createParser());
        this.setXMLReader(this.createReader());
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setSAXParser(SimpleSAXParser parser) {
        this.parser = parser;
    }

    public SimpleSAXParser getSAXParser() {
        return this.parser;
    }

    public void setXMLReader(XMLReader reader) {
        this.reader = reader;
    }

    public XMLReader getXMLReader() {
        return this.reader;
    }

    public InputSource getInputSource() {
        return this.input;
    }

    public void setInputSource(InputSource input) {
        this.input = input;
    }

    public void setInputSource(InputStream input) {
        this.setInputSource(new InputSource(input));
    }

    public void setInputSource(Reader input) {
        this.setInputSource(new InputSource(input));
    }

    public void setInputSource(File input) throws FileNotFoundException {
        this.setInputSource(new FileInputStream(input));
        this.fileName = input.toString();
    }

    public void setInputSource(String systemId) {
        this.setInputSource(new InputSource(systemId));
    }

    public void setInputSourceFileName(String file) throws FileNotFoundException {
        this.setInputSource(new File(file));
    }

    public void execute(String cmd) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("input=" + this.getInputSource() + ",cmd=" + cmd));
        }
        try {
            this.getXMLReader().setContentHandler(this.getSAXParser());
            this.getXMLReader().setDTDHandler(this.getSAXParser());
            this.getXMLReader().setEntityResolver(this.getSAXParser());
            this.getXMLReader().parse(this.getInputSource());
        }
        catch (IOException e) {
            throw new SQLExceptionDecorator(e);
        }
        catch (SAXException e) {
            throw new SQLExceptionDecorator(e);
        }
    }

    protected SimpleSAXParser createParser() {
        return new SimpleSAXParser();
    }

    protected XMLReader createReader() throws SAXException {
        return XMLReaderFactory.createXMLReader();
    }

    public class SimpleSAXParser
    extends DefaultHandler {
        boolean inTheTag = false;
        StringBuffer buf;

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.inTheTag) {
                throw new SAXException("Nested in " + SimpleXmlFile.this.getTag() + " tag not supported : " + qName);
            }
            if (this.matchTag(uri, localName, qName)) {
                this.inTheTag = true;
                this.buf = new StringBuffer();
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.matchTag(uri, localName, qName)) {
                this.inTheTag = false;
                try {
                    this.execute(uri, localName, qName, this.buf.toString());
                }
                catch (SQLException e) {
                    throw new SAXException(e);
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inTheTag) {
                this.buf.append(ch, start, length);
            }
        }

        protected boolean matchTag(String uri, String localName, String qName) {
            return uri.equals(SimpleXmlFile.this.getURI()) && localName.equals(SimpleXmlFile.this.getTag());
        }

        protected void execute(String uri, String localName, String qName, String cmd) throws SQLException, SAXException {
            SimpleXmlFile.this.getNext().execute(cmd);
        }

        protected String getValue(String uri, String localName, Attributes attr) {
            int i = attr.getIndex(uri, localName);
            if (i == -1) {
                return null;
            }
            return attr.getValue(i);
        }

        protected void setLogFile(String file, Class cls) throws SAXException {
            if (file == null) {
                return;
            }
            AbstractOutput e = (AbstractOutput)SimpleXmlFile.this.getPipe().get(cls);
            try {
                e.setOutFileName(file);
            }
            catch (FileNotFoundException ex) {
                throw new SAXException(ex);
            }
        }

        protected boolean toBoolean(String flg) {
            return "true".equalsIgnoreCase(flg);
        }
    }
}

