/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.doclets;

import com.sun.javadoc.RootDoc;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import net.sf.fikin.doclets.AbstractDoclet;
import net.sf.fikin.doclets.TemplateTools;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class VelocityDoclet
extends AbstractDoclet {
    static final Log log = LogFactory.getLog((Class)VelocityDoclet.class);
    public static final String RESOURCE_PATH_PROP = "file.resource.loader.path";
    public static final String RESOURCE_JARS_PATH = "jar.resource.loader.path";
    protected String templateName;
    protected File outFile;
    protected boolean velocityLog = false;
    protected RootDoc root;

    public VelocityDoclet() {
        this.docletOptions.addOption("file", true, "destination file to be generated out of the template");
        this.docletOptions.addOption("template", true, "input velocity template file");
        this.docletOptions.addOption("velocitylog", true, "let velocity generate velocity.log in current dir");
    }

    public static int optionLength(String option) {
        return AbstractDoclet.optionLength(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean startCustom(RootDoc root) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("template=" + this.templateName + ", outFile=" + this.outFile.toString()));
        }
        this.root = root;
        try {
            if (!this.checkIntegrity()) {
                return false;
            }
            FileWriter out = this.newOutput();
            try {
                this.initVelocity();
            }
            catch (Exception e) {
                log.fatal((Object)"Exception while Velocity.init()", (Throwable)e);
                return false;
            }
            VelocityContext context = this.newVelocityContext();
            this.putTemplateObject(context);
            try {
                this.executeTemplate(context, out);
                boolean bl = true;
                return bl;
            }
            catch (ResourceNotFoundException e) {
                log.fatal((Object)"Exception while Velocity.getTemplate", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            catch (ParseErrorException e) {
                log.fatal((Object)"Exception while Velocity.getTemplate", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            catch (MethodInvocationException e) {
                log.fatal((Object)"Exception while Velocity.getTemplate or template.merge", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                log.fatal((Object)"Exception while Velocity.getTemplate or template.merge", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            log.fatal((Object)"Exception while Velocity.init()", (Throwable)e);
            return false;
        }
    }

    protected boolean validateOptionsCustom() {
        String str;
        if (log.isDebugEnabled()) {
            log.debug((Object)("parsedDocletOptions=" + this.parsedDocletOptions));
        }
        if (this.parsedDocletOptions == null) {
            return false;
        }
        if (this.parsedDocletOptions.hasOption("template")) {
            str = this.parsedDocletOptions.getOptionValue("template");
            if (str == null || str.length() == 0) {
                return false;
            }
        } else {
            log.error((Object)"Option \"-template\" is required!");
            return false;
        }
        this.templateName = str;
        if (this.parsedDocletOptions.hasOption("file")) {
            str = this.parsedDocletOptions.getOptionValue("file");
            if (str == null || str.length() == 0) {
                return false;
            }
            this.outFile = new File(str);
        } else if (this.parsedDocletOptions.hasOption("d")) {
            str = this.parsedDocletOptions.getOptionValue("d");
            if (str == null || str.length() == 0) {
                return false;
            }
            this.outFile = new File(str + File.separator + this.templateName);
        } else {
            log.error((Object)"Option \"-d\" or \"-file\" is required!");
            return false;
        }
        if (this.parsedDocletOptions.hasOption("velocitylog")) {
            this.velocityLog = true;
        }
        return true;
    }

    protected VelocityContext newVelocityContext() {
        return new VelocityContext();
    }

    protected void initVelocity() throws Exception {
        String tmp;
        Velocity.setProperty((String)"resource.loader", (Object)"file, class, jar");
        StringBuffer str = new StringBuffer("#\n# specify three resource loaders to use\n#\nresource.loader = file, class, jar\n\n#\n# for the loader we call 'file', set the FileResourceLoader as the\n# class to use, turn off caching, and use 3 directories for templates\n#\nfile.resource.loader.description = Velocity File Resource Loader\nfile.resource.loader.class = org.apache.velocity.runtime.resource.loader.FileResourceLoader\n#file.resource.loader.path = templatedirectory1, anotherdirectory, foo/bar\nfile.resource.loader.cache = false\nfile.resource.loader.modificationCheckInterval = 0\n\n#\n#  for the loader we call 'class', use the ClasspathResourceLoader\n#\nclass.resource.loader.description = Velocity Classpath Resource Loader\nclass.resource.loader.class = org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader\n\n#\n# and finally, for the loader we call 'jar', use the JarResourceLoader\n# and specify two jars to load from\n#\njar.resource.loader.description = Velocity Jar  Resource Loader\njar.resource.loader.class = org.apache.velocity.runtime.resource.loader.JarResourceLoader\n#jar.resource.loader.path = jar:file:/myjarplace/myjar.jar, jar:file:/myjarplace/myjar2.jar");
        if (!this.velocityLog) {
            str.append('\n');
            str.append("runtime.log.logsystem.class");
            str.append("=org.apache.velocity.runtime.log.NullLogSystem");
        }
        if ((tmp = System.getProperty(RESOURCE_PATH_PROP)) != null) {
            str.append('\n');
            str.append(RESOURCE_PATH_PROP);
            str.append("=");
            str.append(tmp);
        }
        if ((tmp = System.getProperty(RESOURCE_JARS_PATH)) != null) {
            str.append('\n');
            str.append(RESOURCE_JARS_PATH);
            str.append("=");
            str.append(tmp);
        }
        Properties p = new Properties();
        p.load(new ByteArrayInputStream(str.toString().getBytes()));
        Velocity.init((Properties)p);
    }

    protected void putTemplateObject(VelocityContext context) {
        context.put("rootDoc", (Object)this.root);
        context.put("systemProperties", (Object)System.getProperties());
        context.put("tools", (Object)new TemplateTools());
    }

    protected void executeTemplate(VelocityContext context, FileWriter out) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, Exception {
        Template template = null;
        template = Velocity.getTemplate((String)this.templateName);
        template.merge((Context)context, (Writer)out);
    }

    protected FileWriter newOutput() throws IOException {
        return new FileWriter(this.outFile);
    }

    protected boolean checkIntegrity() {
        if (this.outFile.exists()) {
            log.info((Object)("Output file " + this.outFile.toString() + " exists, it will overwrite it!"));
        }
        return true;
    }

    static {
        VelocityDoclet.setSingleton(new VelocityDoclet());
    }
}

