/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemplateTools {
    static final Log log = LogFactory.getLog((Class)TemplateTools.class);

    public boolean descendsFrom(ClassDoc cls, String fqClassName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("cls=" + cls + ", fqClassName=" + fqClassName));
        }
        if (cls == null) {
            return false;
        }
        if (cls.qualifiedName().equals(fqClassName)) {
            return true;
        }
        if (this.descendsFrom(cls.superclass(), fqClassName)) {
            return true;
        }
        ClassDoc[] intf = cls.interfaces();
        if (intf != null && intf.length > 0) {
            for (int i = 0; i < intf.length; ++i) {
                if (!this.descendsFrom(intf[i], fqClassName)) continue;
                return true;
            }
        }
        return false;
    }

    public Tag[] getTagsByName(ClassDoc cls, String tagName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("cls=" + cls + ", tagName=" + tagName));
        }
        Vector<Tag> v = new Vector<Tag>();
        Tag[] t = cls.tags();
        if (t != null) {
            for (int i = 0; i < t.length; ++i) {
                if (!t[i].name().equals(tagName)) continue;
                v.add(t[i]);
            }
        }
        t = new Tag[v.size()];
        v.toArray(t);
        return t;
    }

    public Object getFirstTagByName(Doc cls, String tagName) {
        Tag t;
        if (log.isDebugEnabled()) {
            log.debug((Object)("cls=" + cls + ", tagName=" + tagName));
        }
        if ((t = this.getFirstTag(cls, tagName)) == null) {
            return new Boolean(false);
        }
        return t;
    }

    protected Tag getFirstTag(Doc cls, String tagName) {
        Tag[] t;
        if (log.isDebugEnabled()) {
            log.debug((Object)("cls=" + cls + ", tagName=" + tagName));
        }
        if ((t = cls.tags()) != null) {
            for (int i = 0; i < t.length; ++i) {
                if (!t[i].name().equals(tagName)) continue;
                return t[i];
            }
        }
        return null;
    }

    public String getTagText(Doc doc, String tagName, String defaultValue) {
        Tag t = this.getFirstTag(doc, tagName);
        if (t == null) {
            return defaultValue;
        }
        return t.text();
    }

    public MethodDoc[] getAllMethods(ClassDoc cls) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("cls=" + cls));
        }
        Vector arr = new Vector();
        this.getAllMethodsTraverse(cls, arr);
        MethodDoc[] ret = new MethodDoc[arr.size()];
        arr.toArray(ret);
        return ret;
    }

    protected void getAllMethodsTraverse(ClassDoc cls, Vector methods) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("cls=" + cls + ",methods=" + methods));
        }
        if (cls == null) {
            return;
        }
        MethodDoc[] arr = cls.methods();
        if (arr != null && arr.length > 0) {
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] == null) continue;
                methods.add(arr[i]);
            }
        }
        this.getAllMethodsTraverse(cls.superclass(), methods);
    }

    public MethodDoc[] removeOverwitenMethods(MethodDoc[] methods) {
        if (methods == null || methods.length == 0) {
            return methods;
        }
        Vector<MethodDoc> arr = new Vector<MethodDoc>(Arrays.asList(methods));
        for (int i = methods.length - 1; i >= 0; --i) {
            MethodDoc om = methods[i].overriddenMethod();
            if (om == null) continue;
            arr.remove(om);
        }
        MethodDoc[] ret = new MethodDoc[arr.size()];
        arr.toArray(ret);
        return ret;
    }

    public MethodDoc[] getObjectMethods(ClassDoc cls) {
        return this.removeOverwitenMethods(this.getAllMethods(cls));
    }

    public ProgramElementDoc[] getOrderedObjectMethods(ClassDoc cls) {
        return this.sortByName((ProgramElementDoc[])this.removeOverwitenMethods(this.getAllMethods(cls)));
    }

    public ProgramElementDoc[] sortByQualifiedName(ProgramElementDoc[] list) {
        if (list == null || list.length == 0) {
            return list;
        }
        Arrays.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((ProgramElementDoc)o1).qualifiedName().compareTo(((ProgramElementDoc)o2).qualifiedName());
            }
        });
        return list;
    }

    public ProgramElementDoc[] sortByName(ProgramElementDoc[] list) {
        if (list == null || list.length == 0) {
            return list;
        }
        Arrays.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((ProgramElementDoc)o1).name().compareTo(((ProgramElementDoc)o2).name());
            }
        });
        return list;
    }

    public String lpad(String text, String pad, int len) {
        if (pad == null) {
            throw new IllegalArgumentException("pad should not be null");
        }
        if (text == null) {
            text = "";
        }
        if (text.length() >= len) {
            return text;
        }
        StringBuffer buf = new StringBuffer(len);
        while (buf.length() + text.length() < len) {
            buf.append(pad);
        }
        buf.append(text);
        return buf.toString();
    }

    public String rpad(String text, String pad, int len) {
        if (pad == null) {
            throw new IllegalArgumentException("pad should not be null");
        }
        if (text == null) {
            text = "";
        }
        if (text.length() >= len) {
            return text;
        }
        StringBuffer buf = new StringBuffer(len);
        buf.append(text);
        while (buf.length() < len) {
            buf.append(pad);
        }
        return buf.toString();
    }

    public boolean isSetter(MethodDoc m) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("method=" + m));
        }
        return m.isPublic() && !m.isAbstract() && !m.isStatic() && m.parameters().length == 1 && "set".equals(m.name().substring(0, 3)) && "void".equals(m.returnType().toString());
    }

    public boolean isAntNestedElement(MethodDoc m) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("method=" + m));
        }
        if (!m.isPublic() || m.isAbstract() || m.isStatic()) {
            return false;
        }
        if (this.getFirstTag((Doc)m, "@deprecated") != null) {
            return false;
        }
        if (m.name().matches("add[A-Z].*")) {
            return m.parameters() != null && m.parameters().length == 1 && "void".equals(m.returnType().toString());
        }
        if (m.name().matches("create[A-Z].*")) {
            return m.parameters().length == 0 && !"void".equals(m.returnType().toString()) && m.returnType().dimension().length() == 0;
        }
        return false;
    }

    public boolean isAntSetterMethod(MethodDoc m) {
        return this.isSetter(m) && this.getFirstTag((Doc)m, "@deprecated") == null && !m.qualifiedName().startsWith("org.apache.tools.ant.Task.") && !m.qualifiedName().startsWith("org.apache.tools.ant.ProjectComponent.") && !m.qualifiedName().startsWith("java.lang.Object.");
    }

    public boolean isAntTaskClass(ClassDoc cls) {
        return this.descendsFrom(cls, "org.apache.tools.ant.Task") && cls.isPublic() && !cls.isAbstract();
    }

    public String getSetterName(MethodDoc m) {
        return Character.toLowerCase(m.name().charAt(3)) + m.name().substring(4);
    }

    public String getAntNestedElementName(MethodDoc m) {
        String s = m.name().replaceFirst("(^add)|(^create)", "");
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public Object getAntNestedElementCls(MethodDoc m, ClassDoc cls) {
        if (m.name().equals("addText")) {
            return "nested text";
        }
        if (m.name().startsWith("add")) {
            return cls.findClass(m.parameters()[0].type().qualifiedTypeName());
        }
        if (m.name().startsWith("create")) {
            return cls.findClass(m.returnType().qualifiedTypeName());
        }
        return new Boolean(false);
    }
}

