/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.doclets;

import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.RootDoc;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDoclet
extends Doclet {
    static final Log log = LogFactory.getLog((Class)AbstractDoclet.class);
    protected Options docletOptions = new Options();
    protected CommandLine parsedDocletOptions;
    protected static AbstractDoclet singleton;

    public AbstractDoclet() {
        this.docletOptions.addOption("d", true, "destination directory where output file(s) will be generated");
        this.docletOptions.addOption("verbose", false, "print verbose information");
        this.docletOptions.addOption("classpath", true, "javadoc classpath to be used");
        this.docletOptions.addOption("doclet", true, "doclet name to be used by javadoc");
        this.docletOptions.addOption("docletpath", true, "doclet classpath to be used");
        this.docletOptions.addOption("sourcepath", true, "Java sources search path");
        this.docletOptions.addOption("subpackages", true, "");
        this.docletOptions.addOption("encoding", true, "");
        this.docletOptions.addOption("breakiterator", false, "");
        this.docletOptions.addOption("help", false, "");
        this.docletOptions.addOption("Xclasses", false, "");
        this.docletOptions.addOption("Xwerror", false, "");
        this.docletOptions.addOption("private", false, "");
        this.docletOptions.addOption("package", false, "");
        this.docletOptions.addOption("protected", false, "");
        this.docletOptions.addOption("public", false, "");
        this.docletOptions.addOption("source", true, "");
        this.docletOptions.addOption("gj", false, "");
        this.docletOptions.addOption("prompt", false, "");
        this.docletOptions.addOption("sysclasspath", true, "");
        this.docletOptions.addOption("bootclasspath", true, "");
        this.docletOptions.addOption("extdirs", true, "");
        this.docletOptions.addOption("overview", true, "");
        this.docletOptions.addOption("locale", true, "");
        this.docletOptions.addOption("XD", true, "");
    }

    public static boolean start(RootDoc root) {
        return singleton.prototypedStart(root);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        return singleton.prototypedValidOptions(options, reporter);
    }

    public static int optionLength(String option) {
        return singleton.prototypedOptionLength(option);
    }

    public boolean prototypedStart(RootDoc root) {
        if (log.isDebugEnabled()) {
            log.debug((Object)root.toString());
        }
        if (this.parseOptions(root.options()) && this.validateOptionsCustom()) {
            return this.startCustom(root);
        }
        return false;
    }

    public int prototypedOptionLength(String option) {
        Option o = this.docletOptions.getOption(option);
        if (o == null) {
            return 0;
        }
        return o.getArgs() + 1;
    }

    public boolean prototypedValidOptions(String[][] options, DocErrorReporter reporter) {
        if (this.parseOptions(options) && this.validateOptionsCustom()) {
            return true;
        }
        this.printUsage(reporter);
        return false;
    }

    protected static void setSingleton(AbstractDoclet doclet) {
        singleton = doclet;
    }

    protected boolean parseOptions(String[][] options) {
        Vector<String> v = new Vector<String>();
        if (options != null) {
            Iterator i = Arrays.asList(options).iterator();
            while (i.hasNext()) {
                Iterator<String> j = Arrays.asList((String[])i.next()).iterator();
                while (j.hasNext()) {
                    String str = j.next();
                    if (str == null) {
                        str = "";
                    }
                    v.add(str);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("args=" + v.toString()));
        }
        String[] args = new String[v.size()];
        v.toArray(args);
        BasicParser parser = new BasicParser();
        try {
            this.parsedDocletOptions = parser.parse(this.docletOptions, args, false);
            return true;
        }
        catch (ParseException e) {
            log.error((Object)e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug((Object)"wrong command line options given", (Throwable)e);
            }
            return false;
        }
    }

    protected void printUsage(DocErrorReporter reporter) {
        reporter.printError("supported options are:\n" + this.docletOptions.toString());
    }

    protected abstract boolean startCustom(RootDoc var1);

    protected abstract boolean validateOptionsCustom();
}

