/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.ant.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import net.sf.fikin.ant.types.XMLInput;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.cyberneko.html.parsers.DOMParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XHTMLInput
extends XMLInput {
    boolean toXHTML = true;
    File xhtmlData;

    public void setToXHTML(boolean toXHTML) {
        this.toXHTML = toXHTML;
    }

    public void setSaveXHTMLInto(File file) {
        this.xhtmlData = file;
    }

    public InputStream getInputStream(Task task) throws BuildException {
        try {
            if (this.toXHTML) {
                TmpXHTMLData xhtml = this.newXHTMLData();
                this.toXHTMLNecko(new BufferedReader(this.getReader(task)), xhtml.getWtiter());
                if (this.xhtmlData != null) {
                    this.writeToFile(task, this.xhtmlData, xhtml.getString());
                }
                return xhtml.getInputStream();
            }
            return super.getInputStream(task);
        }
        catch (SAXException e) {
            throw new BuildException((Throwable)e, task.getLocation());
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, task.getLocation());
        }
    }

    protected void toXHTMLNecko(BufferedReader in, Writer out) throws SAXException, IOException {
        DOMParser v = new DOMParser();
        v.parse(new InputSource(in));
        XMLSerializer ser = new XMLSerializer(out, new OutputFormat("xhtml", null, true));
        ser.serialize(v.getDocument());
        out.close();
    }

    protected void writeToFile(Task task, File file, String str) throws IOException {
        if (file.exists()) {
            task.log("Overwriting " + file, 3);
        } else {
            task.log("Writing " + file, 3);
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        out.write(str);
        out.close();
    }

    protected TmpXHTMLData newXHTMLData() {
        return new TmpXHTMLData();
    }

    public class TmpXHTMLData {
        StringWriter tmpOut;
        String str;

        public Writer getWtiter() {
            this.str = null;
            this.tmpOut = new StringWriter(2000);
            return this.tmpOut;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.getString().getBytes());
        }

        public String getString() {
            if (this.str == null) {
                this.str = this.tmpOut.toString();
            }
            return this.str;
        }
    }
}

