/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.ant.types;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.sf.fikin.ant.types.DelimitedBufferedWriter;
import net.sf.fikin.ant.types.DelimitedPrintWriter;
import net.sf.fikin.ant.types.PropertyOutputStream;
import net.sf.fikin.ant.types.Type;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Output
implements Type {
    File outFile;
    String outPropertyName;
    String delimiter;
    boolean append = false;
    boolean trim = false;

    public void setFile(File in) {
        this.outFile = in;
    }

    public void setProperty(String propertyName) {
        this.outPropertyName = propertyName;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setAppend(boolean flg) {
        this.append = flg;
    }

    public void setTrim(boolean flg) {
        this.trim = flg;
    }

    public void check(Task task) throws BuildException {
        if (this.outFile == null && (this.outPropertyName == null || this.outPropertyName.length() == 0)) {
            throw new BuildException("File or property must be provided!", task.getLocation());
        }
        if (this.outFile != null && this.outFile.exists()) {
            task.log("File " + this.outFile + " exists, will overwrite it");
        }
    }

    public DelimitedBufferedWriter getWriter(Task task) throws BuildException {
        if (this.outPropertyName != null && this.delimiter == null) {
            this.delimiter = " ";
        } else if (this.outFile != null && this.delimiter == null) {
            this.delimiter = System.getProperty("line.separator");
        }
        return new DelimitedBufferedWriter((Writer)new OutputStreamWriter(this.getOutputStream(task)), this.delimiter);
    }

    public OutputStream getOutputStream(Task task) {
        try {
            OutputStream out = this.outFile != null ? new FileOutputStream(this.outFile, this.append) : new PropertyOutputStream(this.outPropertyName, task, this.append, this.trim);
            return new BufferedOutputStream(out);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, task.getLocation());
        }
    }

    public DelimitedPrintWriter getPrintWriter(Task task) {
        return new DelimitedPrintWriter(this.getWriter(task));
    }
}

