/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.ant.types;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import net.sf.fikin.ant.types.Type;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Input
implements Type {
    File inFile;
    String inText;
    String inPropertyName;

    public void setFile(File in) {
        this.inFile = in;
    }

    public void setProperty(String propertyName) {
        this.inPropertyName = propertyName;
    }

    public void addText(String text) {
        this.inText = text;
    }

    public void check(Task task) throws BuildException {
        if (!(this.inFile != null || this.inText != null && this.inText.length() != 0 || this.inPropertyName != null && this.inPropertyName.length() != 0)) {
            throw new BuildException("File, property or inner text must be provided!", task.getLocation());
        }
        int i = 0;
        i = this.inFile == null ? i : ++i;
        i = this.inPropertyName == null ? i : ++i;
        int n = i = this.inText == null ? i : ++i;
        if (i > 1) {
            throw new BuildException("Only one of file, property or inner text can be provided!", task.getLocation());
        }
        if (this.inFile != null && !this.inFile.exists()) {
            throw new BuildException("File " + this.inFile + " does not exist!", task.getLocation());
        }
    }

    public Reader getReader(Task task) throws BuildException {
        try {
            if (this.inFile != null) {
                return new FileReader(this.inFile);
            }
            if (this.inPropertyName != null) {
                return new StringReader(task.getProject().getProperty(this.inPropertyName));
            }
            return new StringReader(this.inText);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e, task.getLocation());
        }
    }

    public InputStream getInputStream(Task task) throws BuildException {
        try {
            if (this.inFile != null) {
                return new FileInputStream(this.inFile);
            }
            if (this.inPropertyName != null) {
                return new ByteArrayInputStream(task.getProject().getProperty(this.inPropertyName).getBytes());
            }
            return new ByteArrayInputStream(this.inText.getBytes());
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e, task.getLocation());
        }
    }
}

