/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.ant.httpclientanttask;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import net.sf.fikin.ant.httpclientanttask.BaseAntMethod;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.tools.ant.BuildException;

public abstract class BaseResponseAntMethod
extends BaseAntMethod {
    File logFile;
    boolean logAppend = false;
    String logLevel = "content";
    String logProcessAs = "text";
    Writer outTxt;
    OutputStream outBin;

    public void setLogFile(File file) {
        this.logFile = file;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogAppend(boolean appendTo) {
        this.logAppend = appendTo;
    }

    public boolean getLogAppend() {
        return this.logAppend;
    }

    public void setLogLevel(String s) {
        this.logLevel = s;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogProcessAs(String s) {
        this.logProcessAs = s;
    }

    public String getLogProcessAs() {
        return this.logProcessAs;
    }

    protected void setOutWriter(Writer o) {
        this.outTxt = o;
    }

    protected Writer getOutWriter() {
        return this.outTxt;
    }

    protected void setOutStream(OutputStream o) {
        this.outBin = o;
    }

    protected OutputStream getOutStream() {
        return this.outBin;
    }

    protected void check() throws BuildException {
        super.check();
        if (this.getLogProcessAs() == null || !"text".equalsIgnoreCase(this.getLogProcessAs()) && !"xml".equalsIgnoreCase(this.getLogProcessAs()) && !"binary".equalsIgnoreCase(this.getLogProcessAs())) {
            throw new BuildException("\"processAs\" has to be one of: text, xml or binary");
        }
        if (this.getLogLevel() == null || !"header".equalsIgnoreCase(this.getLogLevel()) && !"content".equalsIgnoreCase(this.getLogLevel()) && !"all".equalsIgnoreCase(this.getLogLevel()) && !"none".equalsIgnoreCase(this.getLogLevel())) {
            throw new BuildException("\"log\" has to be one of: header, content, all or none");
        }
    }

    public void after_execute_method() throws BuildException {
        try {
            this.processResponse(this.getHttpMethod());
        }
        catch (FileNotFoundException ioe) {
            throw new BuildException((Throwable)ioe);
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }

    protected void processResponse(HttpMethod method) throws BuildException, FileNotFoundException, IOException {
        this.log("Printing response ...", 4);
        this.initOutputHandler();
        if ("header".equalsIgnoreCase(this.getLogLevel()) || "all".equalsIgnoreCase(this.getLogLevel())) {
            this.log("Printing response header ...", 4);
            Header[] headers = method.getResponseHeaders();
            for (int i = 0; i < headers.length; ++i) {
                this.printString(headers[i].toString());
            }
        }
        if ("content".equalsIgnoreCase(this.getLogLevel()) || "all".equalsIgnoreCase(this.getLogLevel())) {
            this.log("Printing response content ...", 4);
            InputStream instr = method.getResponseBodyAsStream();
            if (instr != null) {
                if ("binary".equalsIgnoreCase(this.getLogProcessAs())) {
                    int len;
                    BufferedInputStream in = new BufferedInputStream(instr);
                    byte[] arr = new byte[8096];
                    while ((len = in.read(arr)) != -1) {
                        this.printBytes(arr, len);
                    }
                } else {
                    String str;
                    BufferedReader in = new BufferedReader(new InputStreamReader(instr));
                    while ((str = in.readLine()) != null) {
                        this.printString(str);
                    }
                }
            }
        }
        this.log("Printing response is over.", 4);
        this.closeOutput();
    }

    protected void printString(String str) throws IOException {
        if (this.getOutWriter() != null) {
            this.getOutWriter().write(str);
            this.getOutWriter().write(System.getProperty("line.separator", "\n"));
        } else if (this.getLogFile() == null) {
            this.log(str, 2);
        } else {
            this.getOutStream().write(str.getBytes());
            this.getOutWriter().write(System.getProperty("line.separator", "\n"));
        }
    }

    protected void printBytes(byte[] arr, int len) throws IOException {
        if (this.getOutWriter() != null) {
            while (len >= 0) {
                this.getOutWriter().write(arr[len--]);
            }
        } else {
            this.getOutStream().write(arr, 0, len);
        }
    }

    protected void closeOutput() throws IOException {
        if (this.getOutWriter() != null) {
            this.getOutWriter().close();
        } else {
            this.getOutStream().close();
        }
    }

    protected void initOutputHandler() throws FileNotFoundException, IOException {
        if ("binary".equalsIgnoreCase(this.getLogProcessAs())) {
            if (this.getLogFile() == null) {
                this.setOutStream(new ProjectLogOutputStream());
            } else {
                this.setOutStream(new FileOutputStream(this.getLogFile(), this.getLogAppend()));
            }
        } else if (this.getLogFile() == null) {
            this.setOutWriter(new ProjectLogWriter());
        } else {
            this.setOutWriter(new FileWriter(this.getLogFile(), this.getLogAppend()));
        }
    }

    public class ProjectLogOutputStream
    extends OutputStream {
        public void write(int b) {
            BaseResponseAntMethod.this.log(Integer.toHexString(b), 2);
        }
    }

    public class ProjectLogWriter
    extends Writer {
        public void write(String str) {
            BaseResponseAntMethod.this.log(str, 2);
        }

        public void write(char[] arr, int off, int len) {
            this.write(new String(arr, off, len));
        }

        public void flush() {
        }

        public void close() {
        }
    }
}

