/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.ant.httpclientanttask;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.fikin.ant.httpclientanttask.AntCredentials;
import net.sf.fikin.ant.httpclientanttask.AntProxy;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Parameter;

public abstract class BaseAntMethod
extends Task {
    static HttpClient client;
    HttpMethod method;
    String url;
    boolean failOnError = true;
    int retryAttempts = 5;
    boolean shutdown = false;
    boolean sslAcceptUntrusted = false;
    int connectionTimeout = 5000;
    AntCredentials userCredentials;
    AntProxy proxy;
    HashSet properties = new HashSet();
    String cookiesPolicy = "compatibility";

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    public void setRetryAttempts(int cnt) {
        this.retryAttempts = cnt;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    public boolean getShutdown() {
        return this.shutdown;
    }

    public void setSslAcceptUntrusted(boolean trust) {
        this.sslAcceptUntrusted = trust;
    }

    public boolean getSslAcceptUntrusted() {
        return this.sslAcceptUntrusted;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int ms) {
        this.connectionTimeout = ms;
    }

    public AntCredentials createUserCredentials() {
        this.userCredentials = new AntCredentials();
        return this.userCredentials;
    }

    public AntCredentials getUserCredentials() {
        return this.userCredentials;
    }

    public AntProxy createProxy() {
        this.proxy = new AntProxy();
        return this.proxy;
    }

    public AntProxy getProxy() {
        return this.proxy;
    }

    public void addProperty(Parameter p) {
        this.getProperties().add(p);
    }

    public HashSet getProperties() {
        return this.properties;
    }

    public void setCookiePolicy(String policy) {
        this.cookiesPolicy = policy;
    }

    public String getCookiePolicy() {
        return this.cookiesPolicy;
    }

    protected HttpMethod getHttpMethod() {
        return this.method;
    }

    protected void setHttpMethod(HttpMethod m) {
        this.method = m;
    }

    protected HttpClient getHttpClient() {
        if (client == null) {
            this.log("Instantiating new HttpClient instance", 4);
            client = new HttpClient();
        }
        return client;
    }

    protected abstract HttpMethod newHttpMethod(String var1);

    protected void clearHttpClient() {
        if (client != null) {
            this.log("Clearing HttpClient instance", 4);
            client = null;
        }
    }

    protected void check() throws BuildException {
        if (this.getUrl() == null || this.getUrl().length() == 0) {
            throw new BuildException("\"url\" must be provided");
        }
        if (this.getCookiePolicy() == null || this.getCookiePolicy().length() == 0) {
            throw new BuildException("\"cookiePolicy\" must be provided");
        }
        if ("compatibility".equalsIgnoreCase(this.getCookiePolicy()) && "ignoreCookies".equalsIgnoreCase(this.getCookiePolicy()) && "netscape".equalsIgnoreCase(this.getCookiePolicy()) && "rfc2109".equalsIgnoreCase(this.getCookiePolicy()) && "default".equalsIgnoreCase(this.getCookiePolicy())) {
            throw new BuildException("\"cookiePolicy\" must be one of: compatibility,ignoreCookies,netscape,rfc2109 or default");
        }
    }

    protected void execute_method() throws BuildException, HttpException, IOException {
        this.log("Execute HTTP request", 4);
        this.getHttpClient().executeMethod(this.getHttpMethod());
    }

    protected void before_execute_method() throws BuildException, HttpException, IOException {
        this.setProperties(this.getHttpMethod());
        this.getHttpClient().getParams().setCookiePolicy(this.getCookiePolicy());
    }

    protected void after_execute_method() throws BuildException, HttpException, IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.check();
        try {
            this.log("Set connection timeout :" + this.getConnectionTimeout(), 4);
            this.getHttpClient().getHttpConnectionManager().getParams().setConnectionTimeout(this.getConnectionTimeout());
            this.setUserCredentials();
            this.setProxy();
            this.log("Using URL :" + this.getUrl(), 4);
            this.log("Instantiate new HttpMethod ...", 4);
            this.setHttpMethod(this.newHttpMethod(this.getUrl()));
            try {
                this.before_execute_method();
                this.execute_method();
                this.after_execute_method();
            }
            catch (HttpException he) {
                throw new BuildException((Throwable)he);
            }
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe);
            }
            finally {
                this.getHttpMethod().releaseConnection();
            }
        }
        catch (BuildException e) {
            if (this.getFailOnError()) {
                throw e;
            }
            this.log(e.toString(), 0);
        }
        finally {
            if (this.getShutdown()) {
                this.clearHttpClient();
            }
        }
    }

    protected void setUserCredentials() {
        if (this.getUserCredentials() != null) {
            this.log("Checking user credentials ...", 4);
            this.getUserCredentials().check();
            this.log("Set user credentials ...", 4);
            this.getHttpClient().getState().setCredentials(this.getUserCredentials().getAuthScope(), this.getUserCredentials().getCredentials());
        }
    }

    protected void setProxy() {
        if (this.getProxy() != null) {
            this.log("Checking proxy settings ...", 4);
            this.getProxy().check();
            this.log("Set proxy ..." + this.getProxy().getUrl(), 4);
            this.getHttpClient().getHostConfiguration().setProxyHost(this.getProxy().getHttpHost());
            if (this.getProxy().getProxyCredentials() != null) {
                this.log("Set proxy credentials ...", 4);
                this.getHttpClient().getState().setProxyCredentials(this.getUserCredentials().getAuthScope(), this.getUserCredentials().getCredentials());
            }
        }
    }

    protected void setProperties(HttpMethod method) {
        Iterator i = this.getProperties().iterator();
        while (i.hasNext()) {
            Parameter p = (Parameter)i.next();
            this.log("HttpClient attribute: " + p.getName() + "=" + p.getValue(), 4);
            method.getParams().setParameter(p.getName(), (Object)p.getValue());
        }
    }
}

