/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.ant.httpclientanttask;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.fikin.ant.httpclientanttask.BaseResponseAntMethod;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartBase;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.tools.ant.BuildException;

public class AntMultipartPostMethod
extends BaseResponseAntMethod {
    HashSet query = new HashSet();

    public MyParamString createPostString() {
        MyParamString p = new MyParamString();
        this.getPost().add(p);
        return p;
    }

    public MyParamFile createPostFile() {
        MyParamFile p = new MyParamFile();
        this.getPost().add(p);
        return p;
    }

    public HashSet getPost() {
        return this.query;
    }

    protected HttpMethod newHttpMethod(String url) {
        return new PostMethod(url);
    }

    protected void before_execute_method() throws BuildException, HttpException, FileNotFoundException, IOException {
        super.before_execute_method();
        this.setPost(this.getHttpMethod());
    }

    protected void setPost(HttpMethod method) throws BuildException, FileNotFoundException {
        PartBase[] parts = new PartBase[this.getPost().size()];
        int indx = 0;
        Iterator i = this.getPost().iterator();
        while (i.hasNext()) {
            MyParam p = (MyParam)i.next();
            this.log("Multipart: " + p.getName(), 4);
            parts[indx++] = p.getPartBase();
        }
        PostMethod m = (PostMethod)this.getHttpMethod();
        m.setRequestEntity((RequestEntity)new MultipartRequestEntity((Part[])parts, m.getParams()));
    }

    public class MyParamString
    extends MyParam {
        String value;

        public void setValue(String text) {
            this.value = text;
        }

        public void check() throws BuildException {
            if (this.value == null) {
                throw new BuildException("\"value\" has to be specified");
            }
            super.check();
        }

        public PartBase getPartBase() throws FileNotFoundException {
            return new StringPart(this.name, this.value, this.charset);
        }
    }

    public class MyParamFile
    extends MyParam {
        File file;
        String contentType;

        public void setFile(File file) {
            this.file = file;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public void check() throws BuildException {
            if (this.file == null) {
                throw new BuildException("\"file\" has to be specified");
            }
            super.check();
        }

        public PartBase getPartBase() throws FileNotFoundException {
            return new FilePart(this.name, (PartSource)new FilePartSource(this.file), this.contentType, this.charset);
        }
    }

    public abstract class MyParam {
        String name;
        String charset;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public void check() throws BuildException {
            if (this.name == null) {
                throw new BuildException("\"name\" has to be specified");
            }
        }

        public abstract PartBase getPartBase() throws FileNotFoundException;
    }
}

