/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.ant.httpclientanttask;

import net.sf.fikin.ant.httpclientanttask.AntAuthScope;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.tools.ant.BuildException;

public class AntCredentials {
    String name;
    String pass;
    String domain;
    String host;
    String type = "basic";
    AntAuthScope authScope = new AntAuthScope();

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setUsername(String username) {
        this.name = username;
    }

    public String getUsername() {
        return this.name;
    }

    public void setPassword(String pswd) {
        this.pass = pswd;
    }

    public String getPassword() {
        return this.pass;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public AntAuthScope createAuthScope() {
        return this.authScope;
    }

    public void check() throws BuildException {
        if (this.getType() == null || this.getType().length() == 0) {
            throw new BuildException("\"type\" has to be given");
        }
        if (!("basic".equalsIgnoreCase(this.getType()) || "digest".equalsIgnoreCase(this.getType()) || "nt".equalsIgnoreCase(this.getType()))) {
            throw new BuildException("\"type\" has to be one of: basic, digest or nt");
        }
        if (this.getUsername() == null || this.getUsername().length() == 0) {
            throw new BuildException("\"username\" has to be given");
        }
        if (this.getPassword() == null || this.getPassword().length() == 0) {
            throw new BuildException("\"password\" has to be given");
        }
    }

    public Credentials getCredentials() {
        if ("nt".equalsIgnoreCase(this.getType())) {
            return new UsernamePasswordCredentials(this.getUsername(), this.getPassword());
        }
        return new NTCredentials(this.getUsername(), this.getPassword(), this.getHost(), this.getDomain());
    }

    public AuthScope getAuthScope() {
        return this.authScope.getAuthScope();
    }
}

