/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import net.sf.fikin.ant.types.Depends;
import net.sf.fikin.ant.types.IfUnless;
import net.sf.fikin.ant.types.Parameter;
import net.sf.fikin.ant.types.XsltParam;
import net.sf.fikin.xml.Xslt;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;

public class XsltTask
extends Task
implements ErrorListener {
    protected Vector inFilesets = new Vector();
    protected Mapper mapperElement = null;
    protected File xslFile;
    protected boolean failOnError = true;
    protected boolean force = false;
    protected boolean reuseLoadedStylesheet = true;
    protected FileUtils fileUtils = FileUtils.newFileUtils();
    protected Factory factory = null;
    protected Vector params = new Vector();
    protected Vector depends = new Vector();
    protected Hashtable paramsHT;
    protected Xslt xslt;

    public void setOut(File outFile) {
        FileNameMapper fnm = new FileNameMapper(){
            String fileName;

            public void setFrom(String from) {
            }

            public void setTo(String to) {
                this.fileName = to;
            }

            public String[] mapFileName(String sourceFileName) {
                return new String[]{this.fileName};
            }
        };
        fnm.setTo(outFile.toString());
        this.add(fnm);
    }

    public void setIn(File inFile) {
        FileSet fs = new FileSet();
        fs.setFile(inFile);
        this.inFilesets.addElement(fs);
    }

    public void setStyle(File xslFile) {
        this.xslFile = xslFile;
    }

    public void addFileset(FileSet set) {
        this.inFilesets.addElement(set);
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public void add(FileNameMapper fileNameMapper) {
        this.createMapper().add(fileNameMapper);
    }

    public void setFailOnError(boolean flg) {
        this.failOnError = flg;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setReloadStylesheet(boolean b) {
        this.reuseLoadedStylesheet = !b;
    }

    public XsltParam createParam() {
        XsltParam p = new XsltParam();
        this.params.addElement(p);
        return p;
    }

    public Depends createDepends() {
        Depends p = new Depends();
        this.depends.addElement(p);
        return p;
    }

    public Factory createFactory() throws BuildException {
        if (this.factory != null) {
            throw new BuildException("'factory' element must be unique");
        }
        this.factory = new Factory();
        return this.factory;
    }

    public void execute() throws BuildException {
        this.check();
        Enumeration e = this.inFilesets.elements();
        while (e.hasMoreElements()) {
            this.scan((FileSet)e.nextElement());
        }
    }

    protected void check() throws BuildException {
        if (this.inFilesets.size() == 0) {
            throw new BuildException("Parameter \"in\" or nested <filesets> is expected");
        }
        if (this.mapperElement.getImplementation() == null) {
            throw new BuildException("Parameter \"out\" or nested <mapper> is expected");
        }
        if (this.xslFile == null) {
            throw new BuildException("Parameter \"style\" is expected");
        }
        if (this.factory != null && this.factory.getName() == null) {
            throw new BuildException("Facotry's \"name\" is expected");
        }
    }

    protected void scan(FileSet fs) {
        DirectoryScanner ds = null;
        try {
            ds = fs.getDirectoryScanner(this.getProject());
        }
        catch (BuildException ex) {
            if (this.failOnError || !ex.getMessage().endsWith(" not found.")) {
                throw ex;
            }
            this.log(ex.getMessage(), 1);
            return;
        }
        String[] srcFiles = ds.getIncludedFiles();
        for (int i = 0; i < srcFiles.length; ++i) {
            this.transform(new File(ds.getBasedir(), srcFiles[i]));
        }
    }

    protected void transform(File inFile) {
        File outFile = this.getOutFile(inFile);
        if (outFile == null) {
            String str = "No output-file mapping for input file " + inFile;
            if (this.failOnError) {
                throw new BuildException(str, this.getLocation());
            }
            this.log(str);
            return;
        }
        if (this.force || !this.isUpToDate(inFile, outFile)) {
            if (outFile.exists()) {
                this.log("Overwiting " + outFile, 3);
            }
            this.log("Using style " + this.xslFile + " to process " + inFile + " into " + outFile, 2);
            this.transform(inFile, outFile);
        } else {
            this.log("Skipping " + outFile + ", the file is up to date", 3);
        }
    }

    protected File getOutFile(File inFile) {
        String[] names = this.mapperElement.getImplementation().mapFileName(inFile.toString());
        if (names == null || names.length == 0 || names[0] == null) {
            return null;
        }
        return new File(names[0]);
    }

    protected boolean isUpToDate(File in, File out) {
        File f;
        IfUnless p;
        if (!this.fileUtils.isUpToDate(in, out)) {
            return false;
        }
        Enumeration e = this.params.elements();
        while (e.hasMoreElements()) {
            p = (XsltParam)e.nextElement();
            f = ((XsltParam)p).getLocation();
            if (f == null || this.fileUtils.isUpToDate(f, out) || !p.shouldUse(this)) continue;
            return false;
        }
        e = this.depends.elements();
        while (e.hasMoreElements()) {
            p = (Depends)e.nextElement();
            f = ((Depends)p).getLocation();
            if (f == null || this.fileUtils.isUpToDate(f, out) || !p.shouldUse(this)) continue;
            return false;
        }
        return true;
    }

    protected void transform(File in, File out) throws BuildException {
        try {
            Xslt xslt = this.getXslt();
            FileWriter o = new FileWriter(out);
            xslt.transform(Xslt.newStreamSource(in), new StreamResult(o), this.getParams());
        }
        catch (IOException e1) {
            throw new BuildException((Throwable)e1, this.getLocation());
        }
        catch (TransformerException e2) {
            throw new BuildException((Throwable)e2, this.getLocation());
        }
        catch (ClassNotFoundException e3) {
            throw new BuildException((Throwable)e3, this.getLocation());
        }
        catch (NoSuchMethodException e3) {
            throw new BuildException((Throwable)e3, this.getLocation());
        }
        catch (InstantiationException e3) {
            throw new BuildException((Throwable)e3, this.getLocation());
        }
        catch (InvocationTargetException e3) {
            throw new BuildException((Throwable)e3, this.getLocation());
        }
        catch (IllegalAccessException e3) {
            throw new BuildException((Throwable)e3, this.getLocation());
        }
    }

    protected Xslt getXslt() throws FileNotFoundException, TransformerConfigurationException, ClassNotFoundException, NoSuchMethodException, InstantiationException, InvocationTargetException, IllegalAccessException {
        if (this.xslt == null || !this.reuseLoadedStylesheet) {
            this.xslt = this.newXslt();
        }
        return this.xslt;
    }

    protected Hashtable getParams() {
        if (this.paramsHT == null) {
            this.paramsHT = this.getParams(this.params.elements());
        }
        return this.paramsHT;
    }

    protected Hashtable getParams(Enumeration e) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        while (e.hasMoreElements()) {
            XsltParam p = (XsltParam)e.nextElement();
            if (!p.shouldUse(this)) continue;
            t.put(p.getName(), p.getValue());
        }
        return t;
    }

    protected Xslt newXslt() throws FileNotFoundException, TransformerConfigurationException, ClassNotFoundException, NoSuchMethodException, InstantiationException, InvocationTargetException, IllegalAccessException {
        Xslt xslt = this.factory == null ? new Xslt(Xslt.newStreamSource(this.xslFile)) : new Xslt(this.newStyleFactory(), Xslt.newStreamSource(this.xslFile));
        xslt.setErrorListener(this);
        return xslt;
    }

    protected TransformerFactory newStyleFactory() throws ClassNotFoundException, NoSuchMethodException, InstantiationException, InvocationTargetException, IllegalAccessException {
        String pName = "javax.xml.transform.TransformerFactory";
        String oldValue = System.getProperty("javax.xml.transform.TransformerFactory");
        System.setProperty("javax.xml.transform.TransformerFactory", this.factory.getName());
        TransformerFactory fact = TransformerFactory.newInstance();
        System.setProperty("javax.xml.transform.TransformerFactory", oldValue == null ? "" : oldValue);
        Enumeration e = this.factory.getAttributes();
        while (e.hasMoreElements()) {
            Parameter p = (Parameter)e.nextElement();
            if (!p.shouldUse(this)) continue;
            fact.setAttribute(p.getName(), p.getValue());
        }
        return fact;
    }

    public void warning(TransformerException exception) throws TransformerException {
        this.log(exception.toString(), 1);
    }

    public void error(TransformerException exception) throws TransformerException {
        if (this.failOnError) {
            throw exception;
        }
        this.log(exception.toString(), 0);
    }

    public void fatalError(TransformerException exception) throws TransformerException {
        throw exception;
    }

    public class Factory
    extends IfUnless {
        private String name;
        private Vector attributes = new Vector();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void addAttribute(Parameter attr) {
            this.attributes.addElement(attr);
        }

        public Enumeration getAttributes() {
            return this.attributes.elements();
        }

        public void check(Task task) throws BuildException {
            Enumeration e = this.attributes.elements();
            while (e.hasMoreElements()) {
                ((Parameter)e.nextElement()).check(task);
            }
        }
    }
}

