/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.ant;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import net.sf.fikin.ant.types.DelimitedPrintWriter;
import net.sf.fikin.ant.types.FactoryLiaison;
import net.sf.fikin.ant.types.FactoryType;
import net.sf.fikin.ant.types.IfUnless;
import net.sf.fikin.ant.types.Namespace;
import net.sf.fikin.ant.types.Output;
import net.sf.fikin.ant.types.XHTMLInput;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MacroDef;
import org.apache.tools.ant.taskdefs.MacroInstance;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathTask
extends Task {
    protected boolean failOnError = true;
    protected Vector namespaces = new Vector();
    protected Vector functions = new Vector();
    protected MacroDef macroDef;
    protected XHTMLInput input;
    protected Output output;
    protected Vector forEachs = new Vector();
    protected FactoryType factory;
    protected XPathFactory xpathFactory;
    protected XPath xpath;
    protected DelimitedPrintWriter out;
    protected MacroInstance macroInstance;
    protected int recordCnt;

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void addNamespace(Namespace ns) {
        this.namespaces.add(ns);
    }

    public Function createFunction() {
        Function func = new Function();
        this.functions.add(func);
        return func;
    }

    public XHTMLInput createInput() {
        if (this.input != null) {
            throw new BuildException("Only one input is allowed!", this.getLocation());
        }
        this.input = new XHTMLInput();
        this.input.setToXHTML(false);
        return this.input;
    }

    public Object createSequential() {
        if (this.macroDef != null) {
            throw new BuildException("Only one sequential is allowed!", this.getLocation());
        }
        this.macroDef = new MacroDef();
        this.macroDef.setProject(this.getProject());
        this.macroDef.setOwningTarget(this.getOwningTarget());
        this.macroDef.setName(this.getTaskName());
        return this.macroDef.createSequential();
    }

    public Output createOutput() {
        if (this.output != null) {
            throw new BuildException("Only one output is allowed!", this.getLocation());
        }
        this.output = new Output();
        return this.output;
    }

    public FactoryType createFactory() {
        if (this.factory != null) {
            throw new BuildException("Only one factory is allowed!", this.getLocation());
        }
        this.factory = new FactoryType();
        return this.factory;
    }

    public ForEach createForEach() {
        ForEach foreach = new ForEach();
        this.forEachs.add(foreach);
        return foreach;
    }

    public void check(Task task) throws BuildException {
        if (this.input == null) {
            throw new BuildException("Input must be specified!", this.getLocation());
        }
        this.input.check(this);
        Enumeration e = this.namespaces.elements();
        while (e.hasMoreElements()) {
            ((Namespace)e.nextElement()).check(this);
        }
        e = this.functions.elements();
        while (e.hasMoreElements()) {
            ((Function)e.nextElement()).check(this);
        }
        if (this.macroDef != null && this.output != null) {
            throw new BuildException("Either sequential or output is allowed!", this.getLocation());
        }
        if (this.output != null) {
            this.output.check(this);
        }
        if (this.forEachs.size() == 0) {
            throw new BuildException("At least one for-each is expected!", this.getLocation());
        }
        e = this.forEachs.elements();
        while (e.hasMoreElements()) {
            ((ForEach)e.nextElement()).check(task);
        }
        if (this.factory != null) {
            this.factory.check(this);
        }
    }

    public void execute() throws BuildException {
        try {
            this.check(this);
            Document dom = this.input.getDocument(this);
            this.xpathFactory = this.newXPathFactory();
            this.xpath = this.xpathFactory.newXPath();
            this.setNamespaces();
            this.setFunctions();
            this.recordCnt = 0;
            Enumeration e = this.forEachs.elements();
            while (e.hasMoreElements()) {
                this.execute(dom, (ForEach)e.nextElement());
            }
        }
        catch (BuildException e) {
            if (this.failOnError) {
                throw e;
            }
            this.log(e.toString(), 1);
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    protected void execute(Node node, ForEach fe) throws BuildException {
        try {
            NodeList nodes = (NodeList)fe.evaluate(node);
            for (int i = 0; i < nodes.getLength(); ++i) {
                StringBuffer buf = new StringBuffer();
                this.execute(nodes.item(i), fe.getValueOf(), buf);
                this.execute(buf.toString());
            }
        }
        catch (XPathExpressionException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    protected void execute(Node node, List selects, StringBuffer appendTo) throws XPathExpressionException {
        Iterator i = selects.iterator();
        while (i.hasNext()) {
            this.execute(node, (Select)i.next(), appendTo);
        }
    }

    protected void execute(Node node, Select select, StringBuffer appendTo) throws XPathExpressionException {
        appendTo.append((String)select.evaluate(node));
    }

    protected void execute(String rowOfData) {
        if (this.recordCnt == 0) {
            this.initOut();
        }
        ++this.recordCnt;
        if (this.out != null) {
            if (this.recordCnt > 1) {
                this.out.print(this.out.getDelimiter());
            }
            this.out.print(rowOfData);
        } else {
            this.macroInstance.setDynamicAttribute("node", rowOfData);
            this.macroInstance.execute();
        }
    }

    protected void initOut() {
        if (this.output != null) {
            this.out = this.output.getPrintWriter(this);
        } else {
            MacroDef.Attribute attribute = new MacroDef.Attribute();
            attribute.setName("node");
            this.macroDef.addConfiguredAttribute(attribute);
            this.macroInstance = new MacroInstance();
            this.macroInstance.setProject(this.getProject());
            this.macroInstance.setOwningTarget(this.getOwningTarget());
            this.macroInstance.setLocation(this.getLocation());
            this.macroInstance.setTaskName(this.getTaskName());
            this.macroInstance.setMacroDef(this.macroDef);
        }
    }

    protected void closeOut() {
        if (this.out != null) {
            this.out.close();
        }
    }

    protected XPathFactory newXPathFactory() throws BuildException {
        try {
            Class<?> cls = Class.forName("net.sf.fikin.ant.types.XPathFactoryLiaison");
            FactoryLiaison fl = (FactoryLiaison)cls.newInstance();
            fl.setFactoryType(this.factory);
            return (XPathFactory)fl.getFactory();
        }
        catch (ClassNotFoundException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
        catch (InstantiationException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
        catch (IllegalAccessException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    protected void setNamespaces() {
        Namespace ns;
        ListOfNS lns = new ListOfNS();
        Enumeration e = this.namespaces.elements();
        while (e.hasMoreElements()) {
            ns = (Namespace)e.nextElement();
            if (!ns.shouldUse(this)) continue;
            lns.addNs(ns);
        }
        e = this.functions.elements();
        while (e.hasMoreElements()) {
            ns = (Function)e.nextElement();
            if (!ns.shouldUse(this)) continue;
            lns.addNs(ns);
        }
        this.xpath.setNamespaceContext(lns);
    }

    protected void setFunctions() {
        ListOfFunctions lns = new ListOfFunctions();
        Enumeration e = this.functions.elements();
        while (e.hasMoreElements()) {
            Function ns = (Function)e.nextElement();
            if (!ns.shouldUse(this)) continue;
            lns.addFunction(ns);
        }
        this.xpath.setXPathFunctionResolver(lns);
    }

    public class ListOfFunctions
    implements XPathFunctionResolver {
        Hashtable functions = new Hashtable();

        public void addFunction(Function f) {
            XPathTask.this.log("addFunction : name=" + f.getName() + ", classname=" + f.getClassname() + ", prefix=" + f.getPrefix() + ",uri=" + f.getUri(), 4);
            this.functions.put(f.getUri() + f.getName(), f);
        }

        public XPathFunction resolveFunction(QName functionName, int arity) {
            Function f = (Function)this.functions.get(functionName.getNamespaceURI() + functionName.getLocalPart());
            if (f != null) {
                return f.getXPathFunction();
            }
            return null;
        }
    }

    public class ListOfNS
    implements NamespaceContext {
        Hashtable prefixes = new Hashtable();

        public void addNs(Namespace ns) {
            XPathTask.this.log("addNs : prefix=" + ns.getPrefix() + ",uri=" + ns.getUri(), 4);
            this.prefixes.put(ns.getPrefix(), ns.getUri());
        }

        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new NullPointerException("Null prefix");
            }
            if ("xml".equals(prefix)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            String ret = (String)this.prefixes.get(prefix);
            if (ret == null) {
                return "";
            }
            return ret;
        }

        public String getPrefix(String namespaceURI) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String namespaceURI) {
            throw new UnsupportedOperationException();
        }
    }

    public class ForEach
    extends Select {
        Vector valueOfs;

        public ForEach() {
            this.valueOfs = new Vector();
        }

        public Object evaluate(Node root) throws XPathExpressionException {
            return this.getExpt().evaluate(root, XPathConstants.NODESET);
        }

        public Select createValueOf() {
            Select valueOf = new Select();
            this.valueOfs.add(valueOf);
            return valueOf;
        }

        public List getValueOf() {
            return this.valueOfs;
        }

        public void check(Task task) throws BuildException {
            super.check(task);
            Enumeration e = this.valueOfs.elements();
            while (e.hasMoreElements()) {
                ((Select)e.nextElement()).check(task);
            }
        }
    }

    public class Select
    extends IfUnless {
        String select;
        XPathExpression expr;

        public void compileXPathExpression() throws XPathExpressionException {
            XPathTask.this.log("Compiling xpath expression " + this.select, 4);
            this.expr = XPathTask.this.xpath.compile(this.select);
        }

        public XPathExpression getExpt() throws XPathExpressionException {
            if (this.expr == null) {
                this.compileXPathExpression();
            }
            return this.expr;
        }

        public Object evaluate(Node root) throws XPathExpressionException {
            return this.getExpt().evaluate(root);
        }

        public void setSelect(String select) {
            this.select = XPathTask.this.getProject().replaceProperties(select);
        }

        public String getSelect() {
            return this.select;
        }

        public void check(Task task) throws BuildException {
            if (this.select == null || this.select.length() == 0) {
                throw new BuildException("Select must be specified!", task.getLocation());
            }
        }
    }

    public class Function
    extends Namespace {
        String fqclsname;
        String funcName;
        boolean isReusable = true;
        Class funcCls;
        XPathFunction funcObj;

        public void setClassname(String fqclsname) {
            this.fqclsname = fqclsname;
        }

        public String getClassname() {
            return this.fqclsname;
        }

        public void setName(String name) {
            this.funcName = name;
        }

        public String getName() {
            return this.funcName;
        }

        public void setIsReusable(boolean flg) {
            this.isReusable = flg;
        }

        public boolean getIsReusable() {
            return this.isReusable;
        }

        public void check(Task task) throws BuildException {
            super.check(task);
            if (this.fqclsname == null || this.fqclsname.length() == 0) {
                throw new BuildException("Classname must be specified!", task.getLocation());
            }
            if (this.funcName == null || this.funcName.length() == 0) {
                throw new BuildException("Function name must be specified!", task.getLocation());
            }
            try {
                this.funcCls = Class.forName(this.fqclsname);
            }
            catch (ClassNotFoundException e) {
                throw new BuildException((Throwable)e, task.getLocation());
            }
            try {
                if (this.isReusable) {
                    this.funcObj = (XPathFunction)this.funcCls.newInstance();
                }
            }
            catch (InstantiationException e) {
                throw new BuildException((Throwable)e, task.getLocation());
            }
            catch (IllegalAccessException e) {
                throw new BuildException((Throwable)e, task.getLocation());
            }
        }

        public XPathFunction getXPathFunction() throws NullPointerException {
            if (this.isReusable) {
                return this.funcObj;
            }
            try {
                return (XPathFunction)this.funcCls.newInstance();
            }
            catch (InstantiationException e) {
                throw new NullPointerException("InstantiationException during creation of function " + this.funcName);
            }
            catch (IllegalAccessException e) {
                throw new NullPointerException("IllegalAccessException during creation of function " + this.funcName);
            }
        }
    }
}

