/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.ant;

import java.io.IOException;
import java.io.Writer;
import net.sf.fikin.ant.types.Output;
import net.sf.fikin.ant.types.XHTMLInput;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;

public class ToXhtml
extends Task {
    protected boolean failOnError = true;
    protected XHTMLInput input;
    protected Output output;

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public XHTMLInput createInput() {
        if (this.input != null) {
            throw new BuildException("Only one input is allowed!", this.getLocation());
        }
        this.input = new XHTMLInput();
        this.input.setToXHTML(false);
        return this.input;
    }

    public Output createOutput() {
        if (this.output != null) {
            throw new BuildException("Only one output is allowed!", this.getLocation());
        }
        this.output = new Output();
        return this.output;
    }

    public void check(Task task) throws BuildException {
        if (this.input == null) {
            throw new BuildException("Input must be specified!", this.getLocation());
        }
        this.input.check(this);
        if (this.output == null) {
            throw new BuildException("Output must be specified!", this.getLocation());
        }
        this.output.check(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Writer out = null;
        try {
            this.check(this);
            Document dom = this.input.getDocument(this);
            out = this.output.getWriter(this);
            try {
                XMLSerializer ser = new XMLSerializer(out, null);
                ser.serialize(dom);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        catch (BuildException e) {
            if (this.failOnError) {
                throw e;
            }
            this.log(e.toString(), 0);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

