/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fikin.ant;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DemuxInputStream;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;

public class EmbeddedAntProject
extends Project {
    PrintStream stdErr;
    PrintStream stdOut;
    InputStream stdIn;
    File buildFile;
    String buildFileName;
    File baseDir;
    BuildLogger logger;
    int loggingLevel = 2;

    private EmbeddedAntProject() {
    }

    public EmbeddedAntProject(File buildFile) throws BuildException {
        if (buildFile == null || !buildFile.exists() || !buildFile.isFile()) {
            throw new BuildException("Build file must be defined and existing");
        }
        this.buildFile = buildFile;
        this.buildFileName = buildFile.toString();
        this.baseDir = buildFile.getParentFile();
    }

    public EmbeddedAntProject(File baseDir, String buildFileName, InputStream buildFileContent) throws BuildException {
        if (baseDir == null || !baseDir.exists()) {
            throw new BuildException("Base dir must be defined and existing");
        }
        if (buildFileName == null || buildFileName.length() == 0) {
            throw new BuildException("Build file name must be defined");
        }
        if (buildFileContent == null) {
            throw new BuildException("Build file content must be defined");
        }
        this.buildFile = this.makeItARealFile(buildFileContent);
        this.buildFileName = buildFileName;
        this.baseDir = baseDir;
    }

    public void init() throws BuildException {
        this.setCoreLoader(null);
        this.setDefaultInputStream(System.in);
        this.setInputHandler((InputHandler)new DefaultInputHandler());
        this.logger = new DefaultLogger();
        this.logger.setMessageOutputLevel(this.loggingLevel);
        this.logger.setOutputPrintStream(System.out);
        this.logger.setErrorPrintStream(System.err);
        this.addBuildListener((BuildListener)this.logger);
        super.init();
        this.setUserProperty("ant.version", Main.getAntVersion());
        this.setUserProperty("ant.file", this.buildFileName);
        this.setBaseDir(this.baseDir);
        ProjectHelper.getProjectHelper().parse((Project)this, (Object)this.buildFile);
        this.setBaseDir(this.baseDir);
    }

    protected File makeItARealFile(InputStream in) throws BuildException {
        try {
            int ret;
            File tmpFile = File.createTempFile("build", "xml");
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmpFile));
            byte[] buf = new byte[4096];
            while ((ret = in.read(buf)) != -1) {
                ((OutputStream)os).write(buf, 0, ret);
            }
            ((OutputStream)os).close();
            return tmpFile;
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setMessageLevel(int level) {
        this.loggingLevel = level;
        if (this.logger != null) {
            this.logger.setMessageOutputLevel(level);
        }
    }

    public void executeTarget(String target) throws BuildException {
        this.executeTarget(target, new String[0][]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTarget(String target, String[][] params) throws BuildException {
        this.stdErr = System.err;
        this.stdOut = System.out;
        this.stdIn = System.in;
        System.setIn((InputStream)new DemuxInputStream((Project)this));
        System.setOut(new NonClosingPS(new PrintStream((OutputStream)new DemuxOutputStream((Project)this, false))));
        System.setErr(new NonClosingPS(new PrintStream((OutputStream)new DemuxOutputStream((Project)this, true))));
        try {
            this.fireBuildStarted();
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    this.setProperty(params[i][0], params[i][1]);
                }
            }
            super.executeTarget(target);
            this.fireBuildFinished(null);
        }
        finally {
            System.setOut(this.stdOut);
            System.setErr(this.stdErr);
            System.setIn(this.stdIn);
        }
    }

    public class NonClosingPS
    extends PrintStream {
        PrintStream out;

        public NonClosingPS(PrintStream out) {
            super(out, false);
            this.out = out;
        }

        public void close() {
        }

        public PrintStream getBase() {
            return this.out;
        }
    }
}

