/*
 * Decompiled with CFR 0.152.
 */
package com.pomodorotechnique.client.ui;

import com.pomodorotechnique.client.ui.PomodoroClientView;
import com.pomodorotechnique.client.ui.timer.Timer;
import com.pomodorotechnique.client.ui.timer.TimerListener;
import com.pomodorotechnique.client.ui.timer.TimerState;
import com.pomodorotechnique.server.PomodoroType;
import com.pomodorotechnique.server.api.NoPomodorosLeftException;
import com.pomodorotechnique.server.api.NotFoundException;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class TraySupport
implements TimerListener {
    private Image img = new BufferedImage(16, 16, 2);
    private static final String TEXT_READY = "Flowkeeper is ready for new tasks";
    private static final Image IMAGE_READY = new ImageIcon(TraySupport.class.getResource("/images/tomato.png")).getImage();
    private static final String TEXT_BUSY = "In a Pomodoro";
    private static final Image IMAGE_BUSY = new ImageIcon(TraySupport.class.getResource("/images/tray-busy.png")).getImage();
    private static final String TEXT_REST = "Having rest";
    private static final Image IMAGE_REST = new ImageIcon(TraySupport.class.getResource("/images/tray-rest.png")).getImage();
    private final TrayIcon trayIcon;
    private final ActionListener exitListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    };
    private final ActionListener settingsListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            TraySupport.this.mainWindow.displaySettings();
        }
    };
    private final ActionListener nextPomodoroListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            try {
                TraySupport.this.mainWindow.startPomodoro();
            }
            catch (NotFoundException ex) {
                Logger.getLogger(TraySupport.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (NoPomodorosLeftException ex) {
                Logger.getLogger(TraySupport.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    };
    private final PopupMenu popup = new PopupMenu();
    private final MenuItem menuExitItem = new MenuItem("Exit");
    private final MenuItem menuSettingsItem = new MenuItem("Settings");
    private final MenuItem menuNextPomodoroItem = new MenuItem("Next Pomodoro");
    private final Timer timer;
    private final PomodoroClientView mainWindow;

    public void pomodoroItemSetEnabled(boolean enabled) {
        this.menuNextPomodoroItem.setEnabled(enabled);
    }

    public TraySupport(Timer timer, final PomodoroClientView mainWindow) {
        this.timer = timer;
        this.mainWindow = mainWindow;
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            this.menuExitItem.addActionListener(this.exitListener);
            this.menuSettingsItem.addActionListener(this.settingsListener);
            this.menuNextPomodoroItem.addActionListener(this.nextPomodoroListener);
            this.popup.add(this.menuNextPomodoroItem);
            this.popup.add(this.menuSettingsItem);
            this.popup.add(this.menuExitItem);
            this.trayIcon = new TrayIcon(IMAGE_READY, TEXT_READY, this.popup);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    mainWindow.getFrame().setVisible(true);
                    mainWindow.getFrame().toFront();
                }
            };
            this.trayIcon.setImageAutoSize(true);
            this.trayIcon.addActionListener(actionListener);
            try {
                tray.add(this.trayIcon);
            }
            catch (AWTException e) {
                e.printStackTrace();
            }
        } else {
            this.trayIcon = null;
        }
    }

    private void displayMessage(String caption, String text) {
        if (this.trayIcon != null) {
            this.trayIcon.displayMessage(caption, text, TrayIcon.MessageType.INFO);
        }
    }

    private void displayMessage(String text) {
        this.displayMessage(null, text);
    }

    private void changeState(TimerState state) {
        if (this.trayIcon == null) {
            return;
        }
        switch (state) {
            case BUSY: {
                this.trayIcon.setToolTip(TEXT_BUSY);
                break;
            }
            case READY: {
                this.trayIcon.setImage(IMAGE_READY);
                this.trayIcon.setToolTip(TEXT_READY);
                this.displayMessage("Ready for new tasks");
                break;
            }
            case REST: {
                this.trayIcon.setToolTip(TEXT_REST);
                this.displayMessage("Time is up, have some rest now");
            }
        }
    }

    public void onPomodoroStarted(PomodoroType pomodoro) {
        this.changeState(TimerState.BUSY);
    }

    public void onWorkCompleted(PomodoroType pomodoro, boolean successfully) {
        this.changeState(TimerState.REST);
    }

    public void onReady() {
        this.changeState(TimerState.READY);
    }

    public void onTick() {
        double angle = this.getCurrentAngle();
        this.updateImage(angle);
        this.updateTooltip();
        if (this.trayIcon != null) {
            this.trayIcon.setImage(this.img);
        }
    }

    private double getCurrentAngle() {
        try {
            long fullTime = this.timer.getProjectedFinishTime().getTime() - this.timer.getStateEnterTime().getTime();
            return 1.0 - (double)this.timer.getTimeLeft() / (double)fullTime;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    private void updateImage(double angle) {
        Graphics gr = this.img.getGraphics();
        gr.setColor(Color.white);
        gr.fillOval(1, 1, 14, 14);
        gr.setColor(Color.getHSBColor((float)(0.5 - angle / 2.0), 1.0f, 1.0f));
        gr.fillArc(1, 1, 14, 14, 90, (int)(-360.0 * angle));
        gr.setColor(Color.darkGray);
        gr.drawOval(1, 1, 14, 14);
        gr.drawLine(8, 8, 8, 1);
        double angleRad = 0.0 - Math.PI * 2 * angle;
        gr.drawLine(8, 8, 8 - (int)(7.0 * Math.sin(angleRad)), 8 - (int)(7.0 * Math.cos(angleRad)));
        gr.setColor(Color.white);
        gr.fillOval(6, 6, 4, 4);
        gr.setColor(Color.darkGray);
        gr.drawOval(6, 6, 4, 4);
    }

    private void updateTooltip() {
        if (this.trayIcon == null) {
            return;
        }
        switch (this.timer.getState()) {
            case BUSY: {
                long minLeft = this.timer.getTimeLeft() / 60000L;
                long secLeft = this.timer.getTimeLeft() % 60000L / 1000L;
                this.trayIcon.setToolTip("In a Pomodoro, " + minLeft + ":" + secLeft + " left");
                break;
            }
            case READY: {
                this.trayIcon.setToolTip(TEXT_READY);
                break;
            }
            case REST: {
                long minLeft = this.timer.getTimeLeft() / 60000L;
                long secLeft = this.timer.getTimeLeft() % 60000L / 1000L;
                this.trayIcon.setToolTip("Having rest, " + minLeft + ":" + secLeft + " left");
            }
        }
    }
}

