/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.jpedal.fonts.Type1;
import org.jpedal.fonts.Type1C;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.tt.conversion.FontTableWriter;
import org.jpedal.fonts.tt.conversion.FontWriter;
import org.jpedal.fonts.tt.conversion.TTFontWriter;

public class CFFWriter
extends Type1
implements FontTableWriter {
    private static boolean debugTopDictOffsets = false;
    String name;
    private byte[][] subrs;
    private String[] glyphNames;
    private byte[][] charstrings;
    private byte[] header;
    private byte[] nameIndex;
    private byte[] topDictIndex;
    private byte[] globalSubrIndex;
    private byte[] encodings;
    private byte[] charsets;
    private byte[] charStringsIndex;
    private byte[] privateDict;
    private byte[] localSubrIndex;
    private byte[] stringIndex;
    private ArrayList<String> strings = new ArrayList();

    public CFFWriter(PdfJavaGlyphs pdfJavaGlyphs, byte[] byArray, String string) {
        String string2;
        int n;
        this.glyphs = pdfJavaGlyphs;
        Map map = pdfJavaGlyphs.getCharStrings();
        Object[] objectArray = map.keySet().toArray();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < map.size(); ++n) {
            string2 = (String)objectArray[n];
            if (string2.startsWith("subrs")) {
                int n5;
                int n6 = Integer.parseInt(string2.replaceAll("[^0-9]", ""));
                if (n6 > n2) {
                    n2 = n6;
                }
                if ((n5 = ((byte[])map.get(string2)).length) <= n3) continue;
                n3 = n5;
                continue;
            }
            ++n4;
        }
        this.subrs = new byte[n2 + 1][];
        this.glyphNames = new String[n4];
        this.charstrings = new byte[n4][];
        n4 = 0;
        for (n = 0; n < map.size(); ++n) {
            string2 = (String)objectArray[n];
            Object v = map.get(string2);
            byte[] byArray2 = (byte[])v;
            if (string2.startsWith("subrs")) {
                int n7 = Integer.parseInt(string2.replaceAll("[^0-9]", ""));
                this.subrs[n7] = byArray2;
                continue;
            }
            this.glyphNames[n4] = string2;
            this.charstrings[n4] = byArray2;
            ++n4;
        }
        this.name = string;
    }

    public int getSIDForString(String string) {
        int n;
        for (n = 0; n < Type1C.type1CStdStrings.length; ++n) {
            if (!string.equals(Type1C.type1CStdStrings[n])) continue;
            return n;
        }
        for (n = 0; n < this.strings.size(); ++n) {
            if (!string.equals(this.strings.get(n))) continue;
            return 391 + n;
        }
        this.strings.add(string);
        return 390 + this.strings.size();
    }

    public byte[] writeTable() throws IOException {
        byte[] byArray;
        byte[] byArray2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.localSubrIndex = new byte[0];
        this.privateDict = this.localSubrIndex;
        this.charStringsIndex = this.localSubrIndex;
        this.charsets = this.localSubrIndex;
        this.encodings = this.localSubrIndex;
        this.stringIndex = this.localSubrIndex;
        this.globalSubrIndex = this.localSubrIndex;
        this.topDictIndex = this.localSubrIndex;
        this.header = new byte[]{TTFontWriter.setNextUint8(1), TTFontWriter.setNextUint8(0), TTFontWriter.setNextUint8(4), TTFontWriter.setNextUint8(2)};
        this.nameIndex = CFFWriter.createIndex(new byte[][]{this.name.getBytes()});
        if (debugTopDictOffsets) {
            System.out.println("Generating first top dict...");
        }
        this.topDictIndex = CFFWriter.createIndex(new byte[][]{this.createTopDict()});
        this.globalSubrIndex = CFFWriter.createIndex(new byte[0][]);
        this.encodings = CFFWriter.createEncodings();
        this.charsets = this.createCharsets();
        this.charStringsIndex = CFFWriter.createIndex(this.charstrings);
        this.privateDict = this.createPrivateDict();
        this.localSubrIndex = CFFWriter.createIndex(this.subrs);
        this.stringIndex = CFFWriter.createIndex(this.createStrings());
        do {
            byArray2 = new byte[this.privateDict.length];
            System.arraycopy(this.privateDict, 0, byArray2, 0, this.privateDict.length);
            this.privateDict = this.createPrivateDict();
        } while (!Arrays.equals(this.privateDict, byArray2));
        do {
            byArray = new byte[this.topDictIndex.length];
            System.arraycopy(this.topDictIndex, 0, byArray, 0, this.topDictIndex.length);
            if (debugTopDictOffsets) {
                System.out.println("Current length is " + byArray.length + ". Testing against new...");
            }
            this.topDictIndex = CFFWriter.createIndex(new byte[][]{this.createTopDict()});
        } while (!Arrays.equals(byArray, this.topDictIndex));
        if (debugTopDictOffsets) {
            System.out.println("Length matches, offsets are now correct.");
        }
        byteArrayOutputStream.write(this.header);
        byteArrayOutputStream.write(this.nameIndex);
        byteArrayOutputStream.write(this.topDictIndex);
        byteArrayOutputStream.write(this.stringIndex);
        byteArrayOutputStream.write(this.globalSubrIndex);
        byteArrayOutputStream.write(this.encodings);
        byteArrayOutputStream.write(this.charsets);
        byteArrayOutputStream.write(this.charStringsIndex);
        byteArrayOutputStream.write(this.privateDict);
        byteArrayOutputStream.write(this.localSubrIndex);
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] createIndex(byte[][] byArray) throws IOException {
        int n;
        int n2 = byArray.length;
        if (n2 == 0) {
            return new byte[]{0, 0};
        }
        int[] nArray = new int[n2 + 1];
        nArray[0] = 1;
        for (n = 1; n < n2 + 1; ++n) {
            nArray[n] = nArray[n - 1] + byArray[n - 1].length;
        }
        n = CFFWriter.getOffsizeForMaxVal(nArray[n2]);
        int n3 = 3 + n * nArray.length + nArray[n2];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
        byteArrayOutputStream.write(TTFontWriter.setNextUint16(n2));
        byteArrayOutputStream.write(TTFontWriter.setNextUint8(n));
        for (int n5 : nArray) {
            byteArrayOutputStream.write(FontWriter.setUintAsBytes(n5, n));
        }
        for (byte[] byArray2 : byArray) {
            byteArrayOutputStream.write(byArray2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] createTopDict() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(FontWriter.set1cNumber(this.getSIDForString("1")));
        byteArrayOutputStream.write(0);
        if (this.copyright != null) {
            byteArrayOutputStream.write(FontWriter.set1cNumber(this.getSIDForString(this.copyright)));
            byteArrayOutputStream.write(1);
        }
        byteArrayOutputStream.write(FontWriter.set1cNumber((int)this.FontBBox[0]));
        byteArrayOutputStream.write(FontWriter.set1cNumber((int)this.FontBBox[1]));
        byteArrayOutputStream.write(FontWriter.set1cNumber((int)this.FontBBox[2]));
        byteArrayOutputStream.write(FontWriter.set1cNumber((int)this.FontBBox[3]));
        byteArrayOutputStream.write(5);
        int n = this.header.length + this.nameIndex.length + this.topDictIndex.length + this.stringIndex.length + this.globalSubrIndex.length;
        if (this.encodings.length != 0) {
            byteArrayOutputStream.write(FontWriter.set1cNumber(n));
            if (debugTopDictOffsets) {
                System.out.println("Encoding offset: " + n);
            }
            byteArrayOutputStream.write(16);
        }
        byteArrayOutputStream.write(FontWriter.set1cNumber(n += this.encodings.length));
        if (debugTopDictOffsets) {
            System.out.println("Charset offset: " + n);
        }
        byteArrayOutputStream.write(15);
        byteArrayOutputStream.write(FontWriter.set1cNumber(n += this.charsets.length));
        if (debugTopDictOffsets) {
            System.out.println("Charstrings offset: " + n);
        }
        byteArrayOutputStream.write(17);
        byteArrayOutputStream.write(FontWriter.set1cNumber(this.privateDict.length));
        byteArrayOutputStream.write(FontWriter.set1cNumber(n += this.charStringsIndex.length));
        if (debugTopDictOffsets) {
            System.out.println("Private offset: " + n);
        }
        byteArrayOutputStream.write(18);
        return byteArrayOutputStream.toByteArray();
    }

    private byte[][] createStrings() {
        byte[][] byArrayArray = new byte[this.strings.size()][];
        for (int i = 0; i < this.strings.size(); ++i) {
            byArrayArray[i] = this.strings.get(i).getBytes();
        }
        return byArrayArray;
    }

    private byte[] createCharsets() {
        String[] stringArray = null;
        for (int i = 0; i < this.glyphNames.length; ++i) {
            if (!this.glyphNames[i].equals(".notdef")) continue;
            stringArray = new String[this.glyphNames.length - 1];
            System.arraycopy(this.glyphNames, 0, stringArray, 0, i);
            System.arraycopy(this.glyphNames, i + 1, stringArray, i, stringArray.length - i);
        }
        if (stringArray == null) {
            stringArray = this.glyphNames;
        }
        byte[] byArray = new byte[stringArray.length * 2 + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            byte[] byArray2 = FontWriter.setUintAsBytes(this.getSIDForString(stringArray[i]), 2);
            byArray[1 + i * 2] = byArray2[0];
            byArray[2 + i * 2] = byArray2[1];
        }
        return byArray;
    }

    private static byte[] createEncodings() {
        return new byte[0];
    }

    private byte[] createPrivateDict() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(FontWriter.set1cNumber(this.privateDict.length));
        byteArrayOutputStream.write(19);
        return byteArrayOutputStream.toByteArray();
    }

    private static byte getOffsizeForMaxVal(int n) {
        byte by = 1;
        while (n > 256) {
            by = (byte)(by + 1);
            n /= 256;
        }
        return by;
    }

    public int getIntValue(int n) {
        return -1;
    }
}

