/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.png;

import com.sun.media.imageioimpl.plugins.png.I18N;
import java.util.Locale;
import javax.imageio.ImageWriteParam;

final class CLibPNGImageWriteParam
extends ImageWriteParam {
    private static final float DEFAULT_COMPRESSION_QUALITY = 0.33333334f;
    private static final String DEFAULT_COMPRESSION_TYPE = "DEFAULT";
    private static final String FILTERED_COMPRESSION_TYPE = "FILTERED";
    private static final String HUFFMAN_COMPRESSION_TYPE = "HUFFMAN_ONLY";
    private static final String[] compressionQualityDescriptions = new String[]{I18N.getString("CLibPNGImageWriteParam0"), I18N.getString("CLibPNGImageWriteParam1"), I18N.getString("CLibPNGImageWriteParam2")};

    CLibPNGImageWriteParam(Locale locale) {
        super(locale);
        this.canWriteCompressed = true;
        this.canWriteProgressive = true;
        this.compressionTypes = new String[]{DEFAULT_COMPRESSION_TYPE, FILTERED_COMPRESSION_TYPE, HUFFMAN_COMPRESSION_TYPE};
        this.compressionQuality = 0.33333334f;
        this.compressionType = DEFAULT_COMPRESSION_TYPE;
    }

    int getStrategy() {
        if (this.compressionType.equals(FILTERED_COMPRESSION_TYPE)) {
            return 1;
        }
        if (this.compressionType.equals(HUFFMAN_COMPRESSION_TYPE)) {
            return 2;
        }
        return 0;
    }

    public String[] getCompressionQualityDescriptions() {
        super.getCompressionQualityDescriptions();
        return compressionQualityDescriptions;
    }

    public float[] getCompressionQualityValues() {
        super.getCompressionQualityValues();
        return new float[]{0.0f, 0.8888889f, 1.0f};
    }

    public void setCompressionMode(int n) {
        if (n == 0) {
            throw new UnsupportedOperationException("mode == MODE_DISABLED");
        }
        super.setCompressionMode(n);
    }

    public void unsetCompression() {
        super.unsetCompression();
        this.compressionQuality = 0.33333334f;
        this.compressionType = DEFAULT_COMPRESSION_TYPE;
    }
}

