/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpd;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Map;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MPDUtility {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int DURATION_UNITS_MASK = 31;

    public static CurrencySymbolPosition getSymbolPosition(int n) {
        CurrencySymbolPosition currencySymbolPosition;
        switch (n) {
            case 1: {
                currencySymbolPosition = CurrencySymbolPosition.AFTER;
                break;
            }
            case 2: {
                currencySymbolPosition = CurrencySymbolPosition.BEFORE_WITH_SPACE;
                break;
            }
            case 3: {
                currencySymbolPosition = CurrencySymbolPosition.AFTER_WITH_SPACE;
                break;
            }
            default: {
                currencySymbolPosition = CurrencySymbolPosition.BEFORE;
            }
        }
        return currencySymbolPosition;
    }

    public static final TimeUnit getDurationTimeUnits(int n) {
        TimeUnit timeUnit;
        switch (n & 0x1F) {
            case 3: {
                timeUnit = TimeUnit.MINUTES;
                break;
            }
            case 4: {
                timeUnit = TimeUnit.ELAPSED_MINUTES;
                break;
            }
            case 5: {
                timeUnit = TimeUnit.HOURS;
                break;
            }
            case 6: {
                timeUnit = TimeUnit.ELAPSED_HOURS;
                break;
            }
            case 8: {
                timeUnit = TimeUnit.ELAPSED_DAYS;
                break;
            }
            case 9: {
                timeUnit = TimeUnit.WEEKS;
                break;
            }
            case 10: {
                timeUnit = TimeUnit.ELAPSED_WEEKS;
                break;
            }
            case 11: {
                timeUnit = TimeUnit.MONTHS;
                break;
            }
            case 12: {
                timeUnit = TimeUnit.ELAPSED_MONTHS;
                break;
            }
            default: {
                timeUnit = TimeUnit.DAYS;
            }
        }
        return timeUnit;
    }

    public static Duration getAdjustedDuration(ProjectFile projectFile, int n, TimeUnit timeUnit) {
        Duration duration;
        switch (timeUnit) {
            case MINUTES: 
            case ELAPSED_MINUTES: {
                double d = (double)n / 10.0;
                duration = Duration.getInstance(d, timeUnit);
                break;
            }
            case HOURS: 
            case ELAPSED_HOURS: {
                double d = (double)n / 600.0;
                duration = Duration.getInstance(d, timeUnit);
                break;
            }
            case DAYS: {
                double d = projectFile.getProjectProperties().getMinutesPerDay().doubleValue() * 10.0;
                double d2 = 0.0;
                if (d != 0.0) {
                    d2 = (double)n / d;
                }
                duration = Duration.getInstance(d2, timeUnit);
                break;
            }
            case ELAPSED_DAYS: {
                double d = 14400.0;
                double d3 = (double)n / d;
                duration = Duration.getInstance(d3, timeUnit);
                break;
            }
            case WEEKS: {
                double d = projectFile.getProjectProperties().getMinutesPerWeek().doubleValue() * 10.0;
                double d4 = 0.0;
                if (d != 0.0) {
                    d4 = (double)n / d;
                }
                duration = Duration.getInstance(d4, timeUnit);
                break;
            }
            case ELAPSED_WEEKS: {
                double d = 100800.0;
                double d5 = (double)n / d;
                duration = Duration.getInstance(d5, timeUnit);
                break;
            }
            case ELAPSED_MONTHS: {
                double d = 432000.0;
                double d6 = (double)n / d;
                duration = Duration.getInstance(d6, timeUnit);
                break;
            }
            case MONTHS: {
                double d = (double)n / 96000.0;
                duration = Duration.getInstance(d, timeUnit);
                break;
            }
            default: {
                duration = Duration.getInstance(n, timeUnit);
            }
        }
        return duration;
    }

    public static final Duration getDuration(double d, TimeUnit timeUnit) {
        double d2;
        switch (timeUnit) {
            case MINUTES: 
            case ELAPSED_MINUTES: {
                d2 = d / 10.0;
                break;
            }
            case HOURS: 
            case ELAPSED_HOURS: {
                d2 = d / 600.0;
                break;
            }
            case DAYS: {
                d2 = d / 4800.0;
                break;
            }
            case ELAPSED_DAYS: {
                d2 = d / 14400.0;
                break;
            }
            case WEEKS: {
                d2 = d / 24000.0;
                break;
            }
            case ELAPSED_WEEKS: {
                d2 = d / 100800.0;
                break;
            }
            case MONTHS: {
                d2 = d / 96000.0;
                break;
            }
            case ELAPSED_MONTHS: {
                d2 = d / 432000.0;
                break;
            }
            default: {
                d2 = d;
            }
        }
        return Duration.getInstance(d2, timeUnit);
    }

    public static void dumpRow(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            System.out.println(entry.getKey() + " = " + object + " ( " + (object == null ? "" : object.getClass().getName()) + ")");
        }
    }

    public static final String hexdump(byte[] byArray, int n, int n2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (byArray != null) {
            int n3;
            int n4 = n + n2;
            for (n3 = n; n3 < n4; ++n3) {
                stringBuilder.append(" ");
                stringBuilder.append(HEX_DIGITS[(byArray[n3] & 0xF0) >> 4]);
                stringBuilder.append(HEX_DIGITS[byArray[n3] & 0xF]);
            }
            if (bl) {
                stringBuilder.append("   ");
                for (n3 = n; n3 < n4; ++n3) {
                    char c = (char)byArray[n3];
                    if (c > '\u00c8' || c < '\u001b') {
                        c = ' ';
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static final String hexdump(byte[] byArray, boolean bl) {
        int n = 0;
        if (byArray != null) {
            n = byArray.length;
        }
        return MPDUtility.hexdump(byArray, 0, n, bl);
    }

    public static final String hexdump(byte[] byArray, boolean bl, int n, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (byArray != null) {
            DecimalFormat decimalFormat = new DecimalFormat("00000");
            for (int i = 0; i < byArray.length; i += n) {
                if (i + n > byArray.length) {
                    n = byArray.length - i;
                }
                stringBuilder.append(string);
                stringBuilder.append(decimalFormat.format(i));
                stringBuilder.append(":");
                stringBuilder.append(MPDUtility.hexdump(byArray, i, n, bl));
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public static final void fileHexDump(String string, byte[] byArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(MPDUtility.hexdump(byArray, true, 16, "").getBytes());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static final void fileHexDump(String string, InputStream inputStream) {
        try {
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            MPDUtility.fileHexDump(string, byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static final void fileDump(String string, byte[] byArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

