/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.common.DateHelper;

public class ProjectCalendarWeek {
    private String m_name;
    private DateRange m_dateRange;
    private ProjectCalendarWeek m_parent;
    private ProjectCalendarHours[] m_hours = new ProjectCalendarHours[7];
    private DayType[] m_days = new DayType[7];
    public static final DateRange DEFAULT_WORKING_MORNING = new DateRange(DateHelper.getTime(8, 0), DateHelper.getTime(12, 0));
    public static final DateRange DEFAULT_WORKING_AFTERNOON = new DateRange(DateHelper.getTime(13, 0), DateHelper.getTime(17, 0));

    public void setName(String string) {
        this.m_name = string;
    }

    public String getName() {
        return this.m_name;
    }

    public DateRange getDateRange() {
        return this.m_dateRange;
    }

    public void setDateRange(DateRange dateRange) {
        this.m_dateRange = dateRange;
    }

    public ProjectCalendarWeek getParent() {
        return this.m_parent;
    }

    void setParent(ProjectCalendarWeek projectCalendarWeek) {
        this.m_parent = projectCalendarWeek;
        for (int i = 0; i < this.m_days.length; ++i) {
            if (this.m_days[i] != null) continue;
            this.m_days[i] = DayType.DEFAULT;
        }
    }

    public boolean isDerived() {
        return this.m_parent != null;
    }

    public ProjectCalendarHours addCalendarHours() {
        return new ProjectCalendarHours(this);
    }

    public ProjectCalendarHours getCalendarHours(Day day) {
        return this.m_hours[day.getValue() - 1];
    }

    public ProjectCalendarHours[] getHours() {
        return this.m_hours;
    }

    public ProjectCalendarHours getHours(Day day) {
        ProjectCalendarHours projectCalendarHours = this.getCalendarHours(day);
        if (projectCalendarHours == null) {
            if (this.m_parent == null) {
                this.addDefaultCalendarHours(day);
                projectCalendarHours = this.getCalendarHours(day);
            } else {
                projectCalendarHours = this.m_parent.getHours(day);
            }
        }
        return projectCalendarHours;
    }

    public void addDefaultCalendarHours() {
        for (int i = 1; i <= 7; ++i) {
            this.addDefaultCalendarHours(Day.getInstance(i));
        }
    }

    public void addDefaultCalendarHours(Day day) {
        ProjectCalendarHours projectCalendarHours = this.addCalendarHours(day);
        if (day != Day.SATURDAY && day != Day.SUNDAY) {
            projectCalendarHours.addRange(DEFAULT_WORKING_MORNING);
            projectCalendarHours.addRange(DEFAULT_WORKING_AFTERNOON);
        }
    }

    public ProjectCalendarHours addCalendarHours(Day day) {
        ProjectCalendarHours projectCalendarHours = new ProjectCalendarHours(this);
        projectCalendarHours.setDay(day);
        this.m_hours[day.getValue() - 1] = projectCalendarHours;
        return projectCalendarHours;
    }

    public void attachHoursToDay(ProjectCalendarHours projectCalendarHours) {
        if (projectCalendarHours.getParentCalendar() != this) {
            throw new IllegalArgumentException();
        }
        this.m_hours[projectCalendarHours.getDay().getValue() - 1] = projectCalendarHours;
    }

    public void removeHoursFromDay(ProjectCalendarHours projectCalendarHours) {
        if (projectCalendarHours.getParentCalendar() != this) {
            throw new IllegalArgumentException();
        }
        this.m_hours[projectCalendarHours.getDay().getValue() - 1] = null;
    }

    public DayType[] getDays() {
        return this.m_days;
    }

    public DayType getWorkingDay(Day day) {
        return this.m_days[day.getValue() - 1];
    }

    public void setWorkingDay(Day day, boolean bl) {
        this.setWorkingDay(day, bl ? DayType.WORKING : DayType.NON_WORKING);
    }

    public void setWorkingDay(Day day, DayType dayType) {
        DayType dayType2 = dayType == null ? (this.isDerived() ? DayType.DEFAULT : DayType.WORKING) : dayType;
        this.m_days[day.getValue() - 1] = dayType2;
    }
}

