/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.File;
import java.io.FileInputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.languagetool.JLanguageTool;
import org.languagetool.server.HTTPSServerConfig;
import org.languagetool.server.IllegalConfigurationException;
import org.languagetool.server.LanguageToolHttpHandler;
import org.languagetool.server.PortBindingException;
import org.languagetool.server.RequestLimiter;
import org.languagetool.server.Server;
import org.languagetool.tools.Tools;

public class HTTPSServer
extends Server {
    private final ExecutorService executorService;

    public HTTPSServer(HTTPSServerConfig config, boolean runInternally, String host, Set<String> allowedIps) {
        this.port = config.getPort();
        this.host = host;
        try {
            this.server = host == null ? HttpsServer.create(new InetSocketAddress(this.port), 0) : HttpsServer.create(new InetSocketAddress(host, this.port), 0);
            SSLContext sslContext = this.getSslContext(config.getKeystore(), config.getKeyStorePassword());
            HttpsConfigurator configurator = this.getConfigurator(sslContext);
            ((HttpsServer)this.server).setHttpsConfigurator(configurator);
            RequestLimiter limiter = this.getRequestLimiterOrNull(config);
            LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
            this.httpHandler = new LanguageToolHttpHandler(config, allowedIps, runInternally, limiter, workQueue);
            this.server.createContext("/", this.httpHandler);
            this.executorService = this.getExecutorService(workQueue, config);
            this.server.setExecutor(this.executorService);
        }
        catch (BindException e) {
            ResourceBundle messages = JLanguageTool.getMessageBundle();
            String message = Tools.i18n(messages, "https_server_start_failed", host, Integer.toString(this.port));
            throw new PortBindingException(message, e);
        }
        catch (Exception e) {
            ResourceBundle messages = JLanguageTool.getMessageBundle();
            String message = Tools.i18n(messages, "https_server_start_failed_unknown_reason", host, Integer.toString(this.port));
            throw new RuntimeException(message, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SSLContext getSslContext(File keyStoreFile, String passPhrase) {
        try (FileInputStream keyStoreStream = new FileInputStream(keyStoreFile);){
            KeyStore keystore = KeyStore.getInstance("JKS");
            keystore.load(keyStoreStream, passPhrase.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keystore, passPhrase.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(keystore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            SSLContext sSLContext = sslContext;
            return sSLContext;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set up SSL context", e);
        }
    }

    private HttpsConfigurator getConfigurator(SSLContext sslContext) {
        return new HttpsConfigurator(sslContext){

            @Override
            public void configure(HttpsParameters params) {
                SSLContext context = this.getSSLContext();
                SSLParameters sslParams = context.getDefaultSSLParameters();
                params.setNeedClientAuth(false);
                params.setSSLParameters(sslParams);
            }
        };
    }

    @Override
    public void stop() {
        super.stop();
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0 || args.length > 7 || HTTPSServer.usageRequested(args)) {
            System.out.println("Usage: " + HTTPSServer.class.getSimpleName() + " --config propertyFile [--port|-p port] [--public]");
            System.out.println("  --config file  a Java property file (one key=value entry per line) with values for:");
            System.out.println("                 'keystore' - a Java keystore with an SSL certificate");
            System.out.println("                 'password' - the keystore's password");
            HTTPSServer.printCommonConfigFileOptions();
            HTTPSServer.printCommonOptions();
            System.exit(1);
        }
        try {
            HTTPSServerConfig config = new HTTPSServerConfig(args);
            try {
                HTTPSServer server;
                if (config.isPublicAccess()) {
                    System.out.println("WARNING: running in public mode, LanguageTool API can be accessed without restrictions!");
                    server = new HTTPSServer(config, false, null, null);
                } else {
                    server = new HTTPSServer(config, false, "localhost", DEFAULT_ALLOWED_IPS);
                }
                server.run();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not start LanguageTool HTTPS server on localhost, port " + config.getPort(), e);
            }
        }
        catch (IllegalConfigurationException e) {
            System.out.println(e.getMessage());
            System.out.println("Note: this is the HTTPS server - if you want to use plain HTTP instead, please see http://languagetool.org/http-server/");
            System.exit(1);
        }
    }

    @Override
    protected String getProtocol() {
        return "https";
    }
}

