/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ca.runner;

import java.util.ArrayList;
import java.util.List;
import org.encog.ca.program.CAProgram;
import org.encog.ca.runner.CARunner;
import org.encog.ca.universe.Universe;
import org.encog.ca.universe.UniverseListener;

public class BasicCARunner
implements CARunner,
Runnable {
    private Universe universe;
    private Universe tempUniverse;
    private CAProgram physics;
    private boolean running;
    private int iteration;
    private double percentChanged;
    private double percentInvalid;
    private List<UniverseListener> listeners = new ArrayList<UniverseListener>();
    private Thread thread;

    public BasicCARunner(Universe theUniverse, CAProgram thePhysics) {
        this.init(theUniverse, thePhysics);
    }

    @Override
    public void init(Universe theUniverse, CAProgram thePhysics) {
        this.universe = theUniverse;
        this.tempUniverse = (Universe)theUniverse.clone();
        this.physics = thePhysics;
    }

    @Override
    public void addListener(UniverseListener listener) {
        this.listeners.add(listener);
    }

    public String toString() {
        return "Iteration: " + this.iteration + ", Diff=" + this.percentChanged + ", Invalid=" + this.percentInvalid + ", Score=" + this.getScore();
    }

    @Override
    public void iteration() {
        this.tempUniverse.copy(this.universe);
        this.physics.setSourceUniverse(this.universe);
        this.physics.setTargetUniverse(this.tempUniverse);
        this.physics.iteration();
        this.percentChanged = this.tempUniverse.compare(this.universe);
        this.percentInvalid = this.tempUniverse.calculatePercentInvalid();
        ++this.iteration;
        this.universe.copy(this.tempUniverse);
        for (UniverseListener listener : this.listeners) {
            listener.iterationComplete();
        }
    }

    @Override
    public void start() {
        if (!this.running) {
            this.running = true;
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    @Override
    public void stop() {
        this.running = false;
        try {
            if (this.thread != null) {
                this.thread.join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            this.iteration();
        }
    }

    @Override
    public void reset() {
        this.physics.randomize();
        this.universe.randomize();
        this.iteration = 0;
    }

    public int runToConverge(int maxIterations) {
        this.iteration = 0;
        do {
            this.iteration();
        } while (!(this.iteration > 5 && this.percentChanged < 0.01) && this.iteration <= maxIterations);
        return this.iteration;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public Universe getUniverse() {
        return this.universe;
    }

    @Override
    public CAProgram getPhysics() {
        return this.physics;
    }

    @Override
    public int runToConverge(int i, double desiredScore) {
        this.iteration = 0;
        do {
            this.iteration();
        } while ((this.iteration < 25 || this.percentChanged > desiredScore) && this.iteration < i);
        return this.iteration;
    }

    @Override
    public double getScore() {
        if (this.percentChanged < 0.2 || this.percentChanged > 0.5) {
            return 0.0;
        }
        double score = 1.0 + (0.5 - (this.percentChanged - 0.2) - this.percentInvalid);
        return score;
    }
}

