/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql.importer;

import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.Util;
import net.sf.jabref.sql.DBConnectDialog;
import net.sf.jabref.sql.DBExporterAndImporterFactory;
import net.sf.jabref.sql.DBImportExportDialog;
import net.sf.jabref.sql.DBStrings;
import net.sf.jabref.sql.SQLUtil;
import net.sf.jabref.sql.importer.DBImporter;

public class DbImportAction
extends AbstractWorker {
    BibtexDatabase database = null;
    MetaData metaData = null;
    String errorMessage = null;
    boolean connectToDB = false;
    private JabRefFrame frame;
    private DBStrings dbs = null;
    ArrayList<Object[]> databases = null;

    public DbImportAction(JabRefFrame frame) {
        this.frame = frame;
    }

    public AbstractAction getAction() {
        return new DbImpAction();
    }

    @Override
    public void init() {
        this.dbs = new DBStrings();
        this.dbs.initialize();
        DBConnectDialog dbd = new DBConnectDialog(this.frame, this.dbs);
        this.dbs = dbd.getDBStrings();
        if (!this.dbs.isConfigValid()) {
            if (!this.dbs.isInitialized()) {
                this.dbs.initialize();
            }
            dbd = new DBConnectDialog(this.frame, this.dbs);
            Util.placeDialog(dbd, this.frame);
            dbd.setVisible(true);
            this.connectToDB = dbd.getConnectToDB();
            if (this.connectToDB) {
                this.dbs = dbd.getDBStrings();
                dbd.dispose();
            }
        } else {
            this.connectToDB = true;
        }
    }

    @Override
    public void run() {
        this.performImport();
    }

    private void performImport() {
        if (this.connectToDB) {
            try {
                this.frame.output(Globals.lang("Attempting SQL import..."));
                DBExporterAndImporterFactory factory = new DBExporterAndImporterFactory();
                DBImporter importer = factory.getImporter(this.dbs.getServerType());
                Connection conn = importer.connectToDB(this.dbs);
                ResultSet rs = SQLUtil.queryAllFromTable(conn, "jabref_database");
                Vector<Vector<String>> matrix = new Vector<Vector<String>>();
                while (rs.next()) {
                    Vector<String> v = new Vector<String>();
                    v.add(rs.getString("database_name"));
                    matrix.add(v);
                }
                if (matrix.size() > 0) {
                    DBImportExportDialog dialogo = new DBImportExportDialog(this.frame, matrix, DBImportExportDialog.DialogType.IMPORTER);
                    if (dialogo.removeAction) {
                        String dbName = dialogo.selectedDB;
                        importer.removeDB(dialogo, dbName, conn, this.metaData);
                        this.performImport();
                    } else if (dialogo.moreThanOne) {
                        this.databases = importer.performImport(null, this.dbs, dialogo.listOfDBs);
                        for (Object[] res : this.databases) {
                            this.database = (BibtexDatabase)res[0];
                            this.metaData = (MetaData)res[1];
                            this.dbs.isConfigValid(true);
                        }
                        this.frame.output(Globals.lang("%0 databases will be imported", Integer.toString(this.databases.size())));
                    } else {
                        this.frame.output(Globals.lang("Importing cancelled"));
                    }
                } else {
                    JOptionPane.showMessageDialog(this.frame, Globals.lang("There are no available databases to be imported"), Globals.lang("Import from SQL database"), 1);
                }
            }
            catch (Exception ex) {
                String preamble = "Could not import from SQL database for the following reason:";
                this.errorMessage = SQLUtil.getExceptionMessage(ex);
                this.dbs.isConfigValid(false);
                JOptionPane.showMessageDialog(this.frame, Globals.lang(preamble) + "\n" + this.errorMessage, Globals.lang("Import from SQL database"), 0);
                this.frame.output(Globals.lang("Error importing from database"));
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void update() {
        if (this.databases == null) {
            return;
        }
        for (Object[] res : this.databases) {
            this.database = (BibtexDatabase)res[0];
            this.metaData = (MetaData)res[1];
            if (this.database == null) continue;
            BasePanel pan = this.frame.addTab(this.database, null, this.metaData, Globals.prefs.get("defaultEncoding"), true);
            pan.metaData().setDBStrings(this.dbs);
            this.frame.setTabTitle(pan, res[2] + "(Imported)", "Imported DB");
            pan.markBaseChanged();
        }
        this.frame.output(Globals.lang("Imported %0 databases successfully", Integer.toString(this.databases.size())));
    }

    class DbImpAction
    extends MnemonicAwareAction {
        public DbImpAction() {
            super(GUIGlobals.getImage("dbImport"));
            this.putValue("Name", "Import from external SQL database");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Util.runAbstractWorker(DbImportAction.this);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

