/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql.exporter;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sf.jabref.Util;
import net.sf.jabref.sql.DBStrings;
import net.sf.jabref.sql.SQLUtil;
import net.sf.jabref.sql.exporter.DBExporter;

public class PostgreSQLExporter
extends DBExporter {
    private static PostgreSQLExporter instance = null;

    private PostgreSQLExporter() {
    }

    public static PostgreSQLExporter getInstance() {
        if (instance == null) {
            instance = new PostgreSQLExporter();
        }
        return instance;
    }

    @Override
    public Connection connectToDB(DBStrings dbstrings) throws Exception {
        this.dbStrings = dbstrings;
        String url = SQLUtil.createJDBCurl(dbstrings, true);
        String drv = "org.postgresql.Driver";
        Class.forName(drv).newInstance();
        Connection conn = DriverManager.getConnection(url, dbstrings.getUsername(), dbstrings.getPassword());
        ResultSet rs = ((Statement)SQLUtil.processQueryWithResults(conn, "SELECT count(*) AS alreadyThere FROM pg_database WHERE datname='" + this.dbStrings.getDatabase() + "'")).getResultSet();
        rs.next();
        if (rs.getInt("alreadyThere") == 0) {
            SQLUtil.processQuery(conn, "CREATE DATABASE " + this.dbStrings.getDatabase());
        }
        rs.getStatement().close();
        conn.close();
        conn = DriverManager.getConnection(url, dbstrings.getUsername(), dbstrings.getPassword());
        this.createPLPGSQLFunction(conn);
        return conn;
    }

    private void createPLPGSQLFunction(Connection conn) throws SQLException {
        SQLUtil.processQuery(conn, "create or replace function create_table_if_not_exists (create_sql text) returns bool as $$BEGIN\tBEGIN\t\tEXECUTE create_sql;\t\tException when duplicate_table THEN\t\tRETURN false;\tEND;\tRETURN true;END;$$Language plpgsql;");
    }

    @Override
    protected void createTables(Object out) throws SQLException {
        SQLUtil.processQuery(out, "SELECT create_table_if_not_exists ('CREATE TABLE jabref_database ( \ndatabase_id SERIAL NOT NULL, \ndatabase_name VARCHAR(64) NOT NULL, \nmd5_path VARCHAR(32) NOT NULL, \nPRIMARY KEY (database_id)\n );')");
        SQLUtil.processQuery(out, "SELECT create_table_if_not_exists ('CREATE TABLE entry_types ( \nentry_types_id    SERIAL, \nlabel TEXT, \n" + SQLUtil.fieldsAsCols(SQLUtil.getAllFields(), " VARCHAR(3) DEFAULT NULL") + ", \n" + "PRIMARY KEY (entry_types_id) \n" + ");')");
        SQLUtil.processQuery(out, "SELECT create_table_if_not_exists ('CREATE TABLE entries ( \nentries_id      SERIAL, \njabref_eid      VARCHAR(" + Util.getMinimumIntegerDigits() + ")   DEFAULT NULL, \n" + "database_id INTEGER, \n" + "entry_types_id  INTEGER DEFAULT NULL, \n" + "cite_key        VARCHAR(100)     DEFAULT NULL, \n" + SQLUtil.fieldsAsCols(SQLUtil.getAllFields(), " TEXT DEFAULT NULL") + ",\n" + "PRIMARY KEY (entries_id), \n" + "FOREIGN KEY (entry_types_id) REFERENCES entry_types (entry_types_id), \n" + "FOREIGN KEY (database_id) REFERENCES jabref_database(database_id) \n" + ");')");
        SQLUtil.processQuery(out, "SELECT create_table_if_not_exists ('CREATE TABLE strings ( \nstrings_id      SERIAL, \nlabel      VARCHAR(100)  DEFAULT NULL, \ncontent    VARCHAR(200)  DEFAULT NULL, \ndatabase_id INTEGER, \nFOREIGN KEY (database_id) REFERENCES jabref_database(database_id), \nPRIMARY KEY (strings_id) \n);')");
        SQLUtil.processQuery(out, "SELECT create_table_if_not_exists ('CREATE TABLE group_types ( \ngroup_types_id  SERIAL, \nlabel   VARCHAR(100)    DEFAULT NULL, \nPRIMARY KEY (group_types_id) \n);')");
        SQLUtil.processQuery(out, "SELECT create_table_if_not_exists ('CREATE TABLE groups ( \ngroups_id       SERIAL, \ngroup_types_id  INTEGER         DEFAULT NULL, \nlabel           VARCHAR(100)    DEFAULT NULL, \ndatabase_id INTEGER, \nparent_id       INTEGER         DEFAULT NULL, \nsearch_field       VARCHAR(100)          DEFAULT NULL, \nsearch_expression  VARCHAR(200)          DEFAULT NULL, \ncase_sensitive  BOOLEAN       DEFAULT NULL, \nreg_exp BOOLEAN DEFAULT NULL, \nhierarchical_context INTEGER DEFAULT NULL, \nFOREIGN KEY (database_id) REFERENCES jabref_database(database_id), \nPRIMARY KEY (groups_id) \n);')");
        SQLUtil.processQuery(out, "SELECT create_table_if_not_exists ('CREATE TABLE entry_group ( \nentries_id       SERIAL, \ngroups_id        INTEGER        DEFAULT NULL, \nFOREIGN KEY (entries_id) REFERENCES entries (entries_id) ON DELETE CASCADE, \nFOREIGN KEY (groups_id)  REFERENCES groups (groups_id), \nPRIMARY KEY (groups_id, entries_id) \n);')");
    }
}

