/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import net.sf.jabref.BibtexEntry;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OAI2Handler
extends DefaultHandler {
    BibtexEntry entry;
    StringBuffer authors;
    String keyname;
    String forenames;
    StringBuffer characters;

    public OAI2Handler(BibtexEntry be) {
        this.entry = be;
    }

    @Override
    public void startDocument() throws SAXException {
        this.authors = new StringBuffer();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        this.characters = new StringBuffer();
    }

    @Override
    public void endElement(String uri, String localName, String qualifiedName) throws SAXException {
        String content = this.characters.toString();
        if (qualifiedName.equals("error")) {
            throw new RuntimeException(content);
        }
        if (qualifiedName.equals("id")) {
            this.entry.setField("eprint", content);
        } else if (qualifiedName.equals("keyname")) {
            this.keyname = content;
        } else if (qualifiedName.equals("forenames")) {
            this.forenames = content;
        } else if (qualifiedName.equals("journal-ref")) {
            String journal = content.replaceFirst("[0-9].*", "");
            this.entry.setField("journal", journal);
            String volume = content.replaceFirst(journal, "");
            volume = volume.replaceFirst(" .*", "");
            this.entry.setField("volume", volume);
            String year = content.replaceFirst(".*?\\(", "");
            year = year.replaceFirst("\\).*", "");
            this.entry.setField("year", year);
            String pages = content.replaceFirst(journal, "");
            pages = pages.replaceFirst(volume, "");
            pages = pages.replaceFirst("\\(" + year + "\\)", "");
            pages = pages.replaceAll(" ", "");
            this.entry.setField("pages", pages);
        } else if (qualifiedName.equals("datestamp")) {
            String year = this.entry.getField("year");
            if (year == null || year.equals("")) {
                this.entry.setField("year", content.replaceFirst("-.*", ""));
            }
        } else if (qualifiedName.equals("title")) {
            this.entry.setField("title", content);
        } else if (qualifiedName.equals("abstract")) {
            this.entry.setField("abstract", content);
        } else if (qualifiedName.equals("comments")) {
            this.entry.setField("comments", content);
        } else if (qualifiedName.equals("report-no")) {
            this.entry.setField("reportno", content);
        } else if (qualifiedName.equals("author")) {
            String author = this.forenames + " " + this.keyname;
            if (this.authors.length() > 0) {
                this.authors.append(" and ");
            }
            this.authors.append(author);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.entry.setField("author", this.authors.toString());
    }
}

