/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.RegExpRule;
import net.sf.jabref.SearchRule;
import net.sf.jabref.SimpleSearchRule;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.UnsupportedVersionException;
import net.sf.jabref.search.SearchExpressionLexer;
import net.sf.jabref.search.SearchExpressionParser;
import net.sf.jabref.search.SearchExpressionTreeParser;
import net.sf.jabref.util.QuotedStringTokenizer;

public class SearchGroup
extends AbstractGroup
implements SearchRule {
    public static final String ID = "SearchGroup:";
    private final String m_searchExpression;
    private final boolean m_caseSensitive;
    private final boolean m_regExp;
    private final AST m_ast;
    private static final SearchExpressionTreeParser m_treeParser = new SearchExpressionTreeParser();
    private final SearchRule m_searchRule;

    public SearchGroup(String name, String searchExpression, boolean caseSensitive, boolean regExp, int context) {
        super(name, context);
        this.m_searchExpression = searchExpression;
        this.m_caseSensitive = caseSensitive;
        this.m_regExp = regExp;
        AST ast = null;
        try {
            SearchExpressionParser parser = new SearchExpressionParser(new SearchExpressionLexer(new StringReader(this.m_searchExpression)));
            parser.caseSensitive = this.m_caseSensitive;
            parser.regex = this.m_regExp;
            parser.searchExpression();
            ast = parser.getAST();
        }
        catch (Exception e) {
            ast = null;
        }
        this.m_ast = ast;
        this.m_searchRule = this.m_ast != null ? this : (this.m_regExp ? new RegExpRule(this.m_caseSensitive) : new SimpleSearchRule(this.m_caseSensitive));
    }

    public static AbstractGroup fromString(String s, BibtexDatabase db, int version) throws Exception {
        if (!s.startsWith(ID)) {
            throw new Exception("Internal error: SearchGroup cannot be created from \"" + s + "\". " + "Please report this on www.sf.net/projects/jabref");
        }
        QuotedStringTokenizer tok = new QuotedStringTokenizer(s.substring(ID.length()), ";", '\\');
        switch (version) {
            case 0: 
            case 1: 
            case 2: {
                String name = tok.nextToken();
                String expression = tok.nextToken();
                boolean caseSensitive = Integer.parseInt(tok.nextToken()) == 1;
                boolean regExp = Integer.parseInt(tok.nextToken()) == 1;
                return new SearchGroup(Util.unquote(name, '\\'), Util.unquote(expression, '\\'), caseSensitive, regExp, 0);
            }
            case 3: {
                String name = tok.nextToken();
                int context = Integer.parseInt(tok.nextToken());
                String expression = tok.nextToken();
                boolean caseSensitive = Integer.parseInt(tok.nextToken()) == 1;
                boolean regExp = Integer.parseInt(tok.nextToken()) == 1;
                return new SearchGroup(Util.unquote(name, '\\'), Util.unquote(expression, '\\'), caseSensitive, regExp, context);
            }
        }
        throw new UnsupportedVersionException("SearchGroup", version);
    }

    @Override
    public String getTypeId() {
        return ID;
    }

    @Override
    public SearchRule getSearchRule() {
        return this;
    }

    public String toString() {
        return ID + Util.quote(this.m_name, ";", '\\') + ";" + this.m_context + ";" + Util.quote(this.m_searchExpression, ";", '\\') + ";" + (this.m_caseSensitive ? "1" : "0") + ";" + (this.m_regExp ? "1" : "0") + ";";
    }

    public String getSearchExpression() {
        return this.m_searchExpression;
    }

    @Override
    public boolean supportsAdd() {
        return false;
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Override
    public AbstractUndoableEdit add(BibtexEntry[] entries) {
        return null;
    }

    @Override
    public AbstractUndoableEdit remove(BibtexEntry[] entries) {
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SearchGroup)) {
            return false;
        }
        SearchGroup other = (SearchGroup)o;
        return this.m_name.equals(other.m_name) && this.m_searchExpression.equals(other.m_searchExpression) && this.m_caseSensitive == other.m_caseSensitive && this.m_regExp == other.m_regExp && this.getHierarchicalContext() == other.getHierarchicalContext();
    }

    @Override
    public boolean contains(Map<String, String> searchOptions, BibtexEntry entry) {
        return this.applyRule(searchOptions, entry) != 0;
    }

    @Override
    public boolean contains(BibtexEntry entry) {
        return this.contains(new HashMap<String, String>(), entry);
    }

    @Override
    public int applyRule(Map<String, String> searchOptions, BibtexEntry entry) {
        if (this.m_ast == null) {
            searchOptions.put("option", this.m_searchExpression);
            return this.m_searchRule.applyRule(searchOptions, entry);
        }
        try {
            return m_treeParser.apply(this.m_ast, entry);
        }
        catch (RecognitionException e) {
            return 0;
        }
    }

    @Override
    public AbstractGroup deepCopy() {
        try {
            return new SearchGroup(this.m_name, this.m_searchExpression, this.m_caseSensitive, this.m_regExp, this.m_context);
        }
        catch (Throwable t) {
            System.err.println("Internal error: Exception " + t + " in SearchGroup.deepCopy(). " + "Please report this on www.sf.net/projects/jabref");
            return null;
        }
    }

    public boolean isCaseSensitive() {
        return this.m_caseSensitive;
    }

    public boolean isRegExp() {
        return this.m_regExp;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public String getDescription() {
        return SearchGroup.getDescriptionForPreview(this.m_searchExpression, this.m_ast, this.m_caseSensitive, this.m_regExp);
    }

    public static String getDescriptionForPreview(String expr, AST ast, boolean caseSensitive, boolean regExp) {
        StringBuffer sb = new StringBuffer();
        if (ast == null) {
            sb.append(regExp ? Globals.lang("This group contains entries in which any field contains the regular expression <b>%0</b>", Util.quoteForHTML(expr)) : Globals.lang("This group contains entries in which any field contains the term <b>%0</b>", Util.quoteForHTML(expr)));
            sb.append(" (").append(caseSensitive ? Globals.lang("case sensitive") : Globals.lang("case insensitive")).append("). ");
            sb.append(Globals.lang("Entries cannot be manually assigned to or removed from this group."));
            sb.append("<p><br>").append(Globals.lang("Hint%c To search specific fields only, enter for example%c<p><tt>author%esmith and title%eelectrical</tt>"));
            return sb.toString();
        }
        sb.append(Globals.lang("This group contains entries in which")).append(" ");
        sb.append(SearchGroup.describeNode(ast, regExp, false, false, false));
        sb.append(". ");
        sb.append(caseSensitive ? Globals.lang("The search is case sensitive.") : Globals.lang("The search is case insensitive."));
        return sb.toString();
    }

    protected static String describeNode(AST node, boolean regExp, boolean not, boolean and, boolean or) {
        StringBuffer sb = new StringBuffer();
        switch (node.getType()) {
            case 20: {
                if (not) {
                    sb.append(Globals.lang("not")).append(" ");
                }
                if (or || not) {
                    sb.append("(");
                }
                sb.append(SearchGroup.describeNode(node.getFirstChild(), regExp, false, true, false)).append(" ").append(Globals.lang("and")).append(" ").append(SearchGroup.describeNode(node.getFirstChild().getNextSibling(), regExp, false, true, false));
                if (or || not) {
                    sb.append(")");
                }
                return sb.toString();
            }
            case 21: {
                if (not) {
                    sb.append(Globals.lang("not")).append(" ");
                }
                if (and || not) {
                    sb.append("(");
                }
                sb.append(SearchGroup.describeNode(node.getFirstChild(), regExp, false, false, true)).append(" ").append(Globals.lang("or")).append(" ").append(SearchGroup.describeNode(node.getFirstChild().getNextSibling(), regExp, false, false, true));
                if (and || not) {
                    sb.append(")");
                }
                return sb.toString();
            }
            case 22: {
                return SearchGroup.describeNode(node.getFirstChild(), regExp, !not, and, or);
            }
        }
        node = node.getFirstChild();
        String field = node.getText();
        boolean regExpFieldSpec = !Pattern.matches("\\w+", field);
        node = node.getNextSibling();
        int type = node.getType();
        node = node.getNextSibling();
        String termQuoted = Util.quoteForHTML(node.getText());
        String fieldSpecQuoted = regExpFieldSpec ? Globals.lang("any field that matches the regular expression <b>%0</b>", Util.quoteForHTML(field)) : Globals.lang("the field <b>%0</b>", Util.quoteForHTML(field));
        switch (type) {
            case 7: 
            case 12: {
                if (regExp) {
                    return not ? Globals.lang("%0 doesn't contain the Regular Expression <b>%1</b>", fieldSpecQuoted, termQuoted) : Globals.lang("%0 contains the Regular Expression <b>%1</b>", fieldSpecQuoted, termQuoted);
                }
                return not ? Globals.lang("%0 doesn't contain the term <b>%1</b>", fieldSpecQuoted, termQuoted) : Globals.lang("%0 contains the term <b>%1</b>", fieldSpecQuoted, termQuoted);
            }
            case 8: 
            case 13: {
                if (regExp) {
                    return not ? Globals.lang("%0 doesn't match the Regular Expression <b>%1</b>", fieldSpecQuoted, termQuoted) : Globals.lang("%0 matches the Regular Expression <b>%1</b>", fieldSpecQuoted, termQuoted);
                }
                return not ? Globals.lang("%0 doesn't match the term <b>%1</b>", fieldSpecQuoted, termQuoted) : Globals.lang("%0 matches the term <b>%1</b>", fieldSpecQuoted, termQuoted);
            }
            case 14: {
                if (regExp) {
                    return not ? Globals.lang("%0 contains the Regular Expression <b>%1</b>", fieldSpecQuoted, termQuoted) : Globals.lang("%0 doesn't contain the Regular Expression <b>%1</b>", fieldSpecQuoted, termQuoted);
                }
                return not ? Globals.lang("%0 contains the term <b>%1</b>", fieldSpecQuoted, termQuoted) : Globals.lang("%0 doesn't contain the term <b>%1</b>", fieldSpecQuoted, termQuoted);
            }
        }
        return "Internal error: Unknown AST node type. Please report this on www.sf.net/projects/jabref";
    }

    @Override
    public String getShortDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("<b>");
        if (Globals.prefs.getBoolean("groupShowDynamic")) {
            sb.append("<i>").append(Util.quoteForHTML(this.getName())).append("</i>");
        } else {
            sb.append(Util.quoteForHTML(this.getName()));
        }
        sb.append("</b> - ");
        sb.append(Globals.lang("dynamic group"));
        sb.append(" (");
        sb.append(Globals.lang("search expression"));
        sb.append(" <b>").append(Util.quoteForHTML(this.m_searchExpression)).append("</b>)");
        switch (this.getHierarchicalContext()) {
            case 2: {
                sb.append(", ").append(Globals.lang("includes subgroups"));
                break;
            }
            case 1: {
                sb.append(", ").append(Globals.lang("refines supergroup"));
                break;
            }
        }
        return sb.toString();
    }

    @Override
    public boolean validateSearchStrings(Map<String, String> searchStrings) {
        return true;
    }
}

