/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JOptionPane;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.export.ExportFormat;
import net.sf.jabref.export.ExportFormats;
import net.sf.jabref.export.IExportFormat;
import net.sf.jabref.export.RtfSelection;

public class ExportToClipboardAction
extends AbstractWorker {
    String message = null;
    private JabRefFrame frame;
    private BibtexDatabase database;

    public ExportToClipboardAction(JabRefFrame frame, BibtexDatabase database) {
        this.frame = frame;
        this.database = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BasePanel panel = this.frame.basePanel();
        if (panel == null) {
            return;
        }
        if (panel.getSelectedEntries().length == 0) {
            this.message = Globals.lang("No entries selected") + ".";
            this.getCallBack().update();
            return;
        }
        Map<String, IExportFormat> m = ExportFormats.getExportFormats();
        ExportFormat[] formats = new ExportFormat[m.size()];
        String[] array = new String[formats.length];
        int piv = 0;
        for (IExportFormat format : m.values()) {
            formats[piv] = format;
            array[piv] = format.getDisplayName();
            ++piv;
        }
        JList<String> list = new JList<String>(array);
        list.setBorder(BorderFactory.createEtchedBorder());
        list.setSelectionInterval(0, 0);
        list.setSelectionMode(0);
        int answer = JOptionPane.showOptionDialog(this.frame, list, Globals.lang("Select format"), 0, 3, null, new String[]{Globals.lang("Ok"), Globals.lang("Cancel")}, Globals.lang("Ok"));
        if (answer == 1) {
            return;
        }
        ExportFormat format = formats[list.getSelectedIndex()];
        Globals.prefs.fileDirForDatabase = this.frame.basePanel().metaData().getFileDirectory("file");
        Globals.prefs.databaseFile = this.frame.basePanel().metaData().getFile();
        File tmp = null;
        Reader reader = null;
        try {
            int s;
            tmp = File.createTempFile("jabrefCb", ".tmp");
            tmp.deleteOnExit();
            BibtexEntry[] bes = panel.getSelectedEntries();
            HashSet<String> entries = new HashSet<String>(bes.length);
            for (BibtexEntry be : bes) {
                entries.add(be.getId());
            }
            format.performExport(this.database, panel.metaData(), tmp.getPath(), panel.getEncoding(), entries);
            StringBuffer sb = new StringBuffer();
            reader = new InputStreamReader((InputStream)new FileInputStream(tmp), panel.getEncoding());
            while ((s = reader.read()) != -1) {
                sb.append((char)s);
            }
            ClipboardOwner owner = new ClipboardOwner(){

                @Override
                public void lostOwnership(Clipboard clipboard, Transferable content) {
                }
            };
            RtfSelection rs = new RtfSelection(sb.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(rs, owner);
            this.message = Globals.lang("Entries exported to clipboard") + ": " + bes.length;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = Globals.lang("Error exporting to clipboard");
            return;
        }
        finally {
            if (tmp != null) {
                tmp.delete();
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public void update() {
        this.frame.output(this.message);
    }
}

