/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;

public class FileHistory
extends JMenu
implements ActionListener {
    JabRefPreferences prefs;
    LinkedList<String> history = new LinkedList();
    JabRefFrame frame;

    public FileHistory(JabRefPreferences prefs, JabRefFrame frame) {
        String name = Globals.menuTitle("Recent files");
        int i = name.indexOf(38);
        if (i >= 0) {
            this.setText(name.substring(0, i) + name.substring(i + 1));
            char mnemonic = Character.toUpperCase(name.charAt(i + 1));
            this.setMnemonic((int)mnemonic);
        } else {
            this.setText(name);
        }
        this.prefs = prefs;
        this.frame = frame;
        String[] old = prefs.getStringArray("recentFiles");
        if (old != null && old.length > 0) {
            for (i = 0; i < old.length; ++i) {
                this.history.addFirst(old[i]);
            }
            this.setItems();
        } else {
            this.setEnabled(false);
        }
    }

    public void newFile(String filename) {
        for (int i = 0; i < this.history.size(); ++i) {
            if (!this.history.get(i).equals(filename)) continue;
            this.history.remove(i--);
        }
        this.history.addFirst(filename);
        while (this.history.size() > this.prefs.getInt("historySize")) {
            this.history.removeLast();
        }
        this.setItems();
        if (!this.isEnabled()) {
            this.setEnabled(true);
        }
    }

    private void setItems() {
        this.removeAll();
        Iterator i = this.history.iterator();
        int count = 1;
        while (i.hasNext()) {
            this.addItem((String)i.next(), count++);
        }
    }

    private void addItem(String filename, int num) {
        String number = num + "";
        JMenuItem item = new JMenuItem(number + ". " + filename);
        char mnemonic = Character.toUpperCase(number.charAt(0));
        item.setMnemonic((int)mnemonic);
        item.addActionListener(this);
        this.add(item);
    }

    private void removeItem(String filename) {
        for (int i = 0; i < this.history.size(); ++i) {
            if (!this.history.get(i).equals(filename)) continue;
            this.history.remove(i);
            this.setItems();
            return;
        }
    }

    public void storeHistory() {
        if (this.history.size() > 0) {
            String[] names = new String[this.history.size()];
            for (int i = 0; i < names.length; ++i) {
                names[i] = this.history.get(i);
            }
            this.prefs.putStringArray("recentFiles", names);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String name = ((JMenuItem)e.getSource()).getText();
        int pos = name.indexOf(" ");
        final File fileToOpen = new File(name = name.substring(pos + 1));
        if (!fileToOpen.exists()) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("File not found") + ": " + fileToOpen.getName(), "Error", 0);
            this.removeItem(name);
            return;
        }
        new Thread(){

            @Override
            public void run() {
                FileHistory.this.frame.open.openIt(fileToOpen, true);
            }
        }.start();
    }
}

